// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class RestoreFromClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * Reserved.
     */
    val additionalInfo: String? = builder.additionalInfo
    /**
     * If true, major version upgrades can be applied during the maintenance
     * window to the Amazon Redshift engine that is running on the cluster.
     * Default: true
     */
    val allowVersionUpgrade: Boolean? = builder.allowVersionUpgrade
    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.
     * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
     * disabled - Don't use AQUA.
     * auto - Amazon Redshift determines whether to use AQUA.
     */
    val aquaConfigurationStatus: AquaConfigurationStatus? = builder.aquaConfigurationStatus
    /**
     * The number of days that automated snapshots are retained. If the value is 0,
     * automated snapshots are disabled. Even if automated snapshots are disabled, you can
     * still create manual snapshots when you want with CreateClusterSnapshot.
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     * Default: The value selected for the cluster from which the snapshot was
     * taken.
     * Constraints: Must be a value from 0 to 35.
     */
    val automatedSnapshotRetentionPeriod: Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The Amazon EC2 Availability Zone in which to restore the cluster.
     * Default: A random, system-chosen Availability Zone.
     * Example: us-east-2a
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.
     */
    val availabilityZoneRelocation: Boolean? = builder.availabilityZoneRelocation
    /**
     * The identifier of the cluster that will be created from restoring the
     * snapshot.
     * Constraints:
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * Alphabetic characters must be lowercase.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Must be unique for all clusters within an Amazon Web Services account.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The name of the parameter group to be associated with this cluster.
     * Default: The default Amazon Redshift cluster parameter group. For information about the
     * default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
     * Redshift Parameter Groups.
     * Constraints:
     * Must be 1 to 255 alphanumeric characters or hyphens.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val clusterParameterGroupName: String? = builder.clusterParameterGroupName
    /**
     * A list of security groups to be associated with this cluster.
     * Default: The default cluster security group for Amazon Redshift.
     * Cluster security groups only apply to clusters outside of VPCs.
     */
    val clusterSecurityGroups: List<String>? = builder.clusterSecurityGroups
    /**
     * The name of the subnet group where you want to cluster restored.
     * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
     * provide subnet group name where you want the cluster restored.
     */
    val clusterSubnetGroupName: String? = builder.clusterSubnetGroupName
    /**
     * The elastic IP (EIP) address for the cluster.
     */
    val elasticIp: String? = builder.elasticIp
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing
     * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
     * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
     * the Amazon Redshift Cluster Management Guide.
     * If this option is true, enhanced VPC routing is enabled.
     * Default: false
     */
    val enhancedVpcRouting: Boolean? = builder.enhancedVpcRouting
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
     * retrieve the data encryption keys stored in an HSM.
     */
    val hsmClientCertificateIdentifier: String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the
     * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    val hsmConfigurationIdentifier: String? = builder.hsmConfigurationIdentifier
    /**
     * A list of Identity and Access Management (IAM) roles that can be used by the
     * cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
     * Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
     * request.
     * A cluster can have up to 10 IAM roles associated at any time.
     */
    val iamRoles: List<String>? = builder.iamRoles
    /**
     * The Key Management Service (KMS) key ID of the encryption key that you want to
     * use to encrypt data in the cluster that you restore from a shared snapshot.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the restored cluster. When you take a snapshot,
     * the snapshot inherits the MaintenanceTrack value from the cluster. The
     * snapshot might be on a different track than the cluster that was the source for the
     * snapshot. For example, suppose that you take a snapshot of a cluster that is on the
     * current track and then change the cluster to be on the trailing track. In this case, the
     * snapshot and the source cluster are on different tracks.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the
     * snapshot is retained indefinitely. This setting doesn't change the retention period
     * of existing snapshots.
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The node type that the restored cluster will be provisioned with.
     * Default: The node type of the cluster from which the snapshot was taken. You can
     * modify this if you are using any DS node type. In that case, you can choose to restore
     * into another DS node type of the same size. For example, you can restore ds1.8xlarge
     * into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
     * must restore into that same instance type and size. In other words, you can only restore
     * a dc1.large instance type into another dc1.large instance type or dc2.large instance
     * type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
     * cluster, then resize to a dc2.8large cluster. For more information about node types, see
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
     * About Clusters and Nodes in the Amazon Redshift Cluster Management Guide.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The number of nodes specified when provisioning the restored cluster.
     */
    val numberOfNodes: Int? = builder.numberOfNodes
    /**
     * The Amazon Web Services account used to create or copy the snapshot. Required if you are
     * restoring a snapshot you do not own, optional if you own the snapshot.
     */
    val ownerAccount: String? = builder.ownerAccount
    /**
     * The port number on which the cluster accepts connections.
     * Default: The same port as the original cluster.
     * Constraints: Must be between 1115 and 65535.
     */
    val port: Int? = builder.port
    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can
     * occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * Default: The value selected for the cluster from which the snapshot was taken. For
     * more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows in Amazon Redshift Cluster Management Guide.
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * If true, the cluster can be accessed from a public network.
     */
    val publiclyAccessible: Boolean? = builder.publiclyAccessible
    /**
     * The name of the cluster the source snapshot was created from. This parameter is
     * required if your IAM user has a policy containing a snapshot resource element that
     * specifies anything other than * for the cluster name.
     */
    val snapshotClusterIdentifier: String? = builder.snapshotClusterIdentifier
    /**
     * The name of the snapshot from which to create the new cluster. This parameter isn't
     * case sensitive.
     * Example: my-snapshot-id
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * A unique identifier for the snapshot schedule.
     */
    val snapshotScheduleIdentifier: String? = builder.snapshotScheduleIdentifier
    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the
     * cluster.
     * Default: The default VPC security group is associated with the cluster.
     * VPC security groups only apply to clusters in VPCs.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RestoreFromClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreFromClusterSnapshotRequest(")
        append("additionalInfo=$additionalInfo,")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("aquaConfigurationStatus=$aquaConfigurationStatus,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocation=$availabilityZoneRelocation,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterParameterGroupName=$clusterParameterGroupName,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("elasticIp=$elasticIp,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("ownerAccount=$ownerAccount,")
        append("port=$port,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("snapshotClusterIdentifier=$snapshotClusterIdentifier,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (allowVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (aquaConfigurationStatus?.hashCode() ?: 0)
        result = 31 * result + (automatedSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocation?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (elasticIp?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (hsmClientCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (snapshotClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RestoreFromClusterSnapshotRequest

        if (additionalInfo != other.additionalInfo) return false
        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (aquaConfigurationStatus != other.aquaConfigurationStatus) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocation != other.availabilityZoneRelocation) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterParameterGroupName != other.clusterParameterGroupName) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (elasticIp != other.elasticIp) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (ownerAccount != other.ownerAccount) return false
        if (port != other.port) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (snapshotClusterIdentifier != other.snapshotClusterIdentifier) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RestoreFromClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RestoreFromClusterSnapshotRequest
        /**
         * Reserved.
         */
        fun additionalInfo(additionalInfo: String): FluentBuilder
        /**
         * If true, major version upgrades can be applied during the maintenance
         * window to the Amazon Redshift engine that is running on the cluster.
         * Default: true
         */
        fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder
        /**
         * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.
         * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
         * disabled - Don't use AQUA.
         * auto - Amazon Redshift determines whether to use AQUA.
         */
        fun aquaConfigurationStatus(aquaConfigurationStatus: AquaConfigurationStatus): FluentBuilder
        /**
         * The number of days that automated snapshots are retained. If the value is 0,
         * automated snapshots are disabled. Even if automated snapshots are disabled, you can
         * still create manual snapshots when you want with CreateClusterSnapshot.
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * Default: The value selected for the cluster from which the snapshot was
         * taken.
         * Constraints: Must be a value from 0 to 35.
         */
        fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The Amazon EC2 Availability Zone in which to restore the cluster.
         * Default: A random, system-chosen Availability Zone.
         * Example: us-east-2a
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.
         */
        fun availabilityZoneRelocation(availabilityZoneRelocation: Boolean): FluentBuilder
        /**
         * The identifier of the cluster that will be created from restoring the
         * snapshot.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The name of the parameter group to be associated with this cluster.
         * Default: The default Amazon Redshift cluster parameter group. For information about the
         * default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
         * Redshift Parameter Groups.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun clusterParameterGroupName(clusterParameterGroupName: String): FluentBuilder
        /**
         * A list of security groups to be associated with this cluster.
         * Default: The default cluster security group for Amazon Redshift.
         * Cluster security groups only apply to clusters outside of VPCs.
         */
        fun clusterSecurityGroups(clusterSecurityGroups: List<String>): FluentBuilder
        /**
         * The name of the subnet group where you want to cluster restored.
         * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
         * provide subnet group name where you want the cluster restored.
         */
        fun clusterSubnetGroupName(clusterSubnetGroupName: String): FluentBuilder
        /**
         * The elastic IP (EIP) address for the cluster.
         */
        fun elasticIp(elasticIp: String): FluentBuilder
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the
         * cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
         * Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
         * request.
         * A cluster can have up to 10 IAM roles associated at any time.
         */
        fun iamRoles(iamRoles: List<String>): FluentBuilder
        /**
         * The Key Management Service (KMS) key ID of the encryption key that you want to
         * use to encrypt data in the cluster that you restore from a shared snapshot.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the maintenance track for the restored cluster. When you take a snapshot,
         * the snapshot inherits the MaintenanceTrack value from the cluster. The
         * snapshot might be on a different track than the cluster that was the source for the
         * snapshot. For example, suppose that you take a snapshot of a cluster that is on the
         * current track and then change the cluster to be on the trailing track. In this case, the
         * snapshot and the source cluster are on different tracks.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the
         * snapshot is retained indefinitely. This setting doesn't change the retention period
         * of existing snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The node type that the restored cluster will be provisioned with.
         * Default: The node type of the cluster from which the snapshot was taken. You can
         * modify this if you are using any DS node type. In that case, you can choose to restore
         * into another DS node type of the same size. For example, you can restore ds1.8xlarge
         * into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
         * must restore into that same instance type and size. In other words, you can only restore
         * a dc1.large instance type into another dc1.large instance type or dc2.large instance
         * type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
         * cluster, then resize to a dc2.8large cluster. For more information about node types, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
         * About Clusters and Nodes in the Amazon Redshift Cluster Management Guide.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The number of nodes specified when provisioning the restored cluster.
         */
        fun numberOfNodes(numberOfNodes: Int): FluentBuilder
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are
         * restoring a snapshot you do not own, optional if you own the snapshot.
         */
        fun ownerAccount(ownerAccount: String): FluentBuilder
        /**
         * The port number on which the cluster accepts connections.
         * Default: The same port as the original cluster.
         * Constraints: Must be between 1115 and 65535.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The weekly time range (in UTC) during which automated cluster maintenance can
         * occur.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * Default: The value selected for the cluster from which the snapshot was taken. For
         * more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows in Amazon Redshift Cluster Management Guide.
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * Constraints: Minimum 30-minute window.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * If true, the cluster can be accessed from a public network.
         */
        fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder
        /**
         * The name of the cluster the source snapshot was created from. This parameter is
         * required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         */
        fun snapshotClusterIdentifier(snapshotClusterIdentifier: String): FluentBuilder
        /**
         * The name of the snapshot from which to create the new cluster. This parameter isn't
         * case sensitive.
         * Example: my-snapshot-id
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * A unique identifier for the snapshot schedule.
         */
        fun snapshotScheduleIdentifier(snapshotScheduleIdentifier: String): FluentBuilder
        /**
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the
         * cluster.
         * Default: The default VPC security group is associated with the cluster.
         * VPC security groups only apply to clusters in VPCs.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Reserved.
         */
        var additionalInfo: String?
        /**
         * If true, major version upgrades can be applied during the maintenance
         * window to the Amazon Redshift engine that is running on the cluster.
         * Default: true
         */
        var allowVersionUpgrade: Boolean?
        /**
         * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.
         * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
         * disabled - Don't use AQUA.
         * auto - Amazon Redshift determines whether to use AQUA.
         */
        var aquaConfigurationStatus: AquaConfigurationStatus?
        /**
         * The number of days that automated snapshots are retained. If the value is 0,
         * automated snapshots are disabled. Even if automated snapshots are disabled, you can
         * still create manual snapshots when you want with CreateClusterSnapshot.
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * Default: The value selected for the cluster from which the snapshot was
         * taken.
         * Constraints: Must be a value from 0 to 35.
         */
        var automatedSnapshotRetentionPeriod: Int?
        /**
         * The Amazon EC2 Availability Zone in which to restore the cluster.
         * Default: A random, system-chosen Availability Zone.
         * Example: us-east-2a
         */
        var availabilityZone: String?
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.
         */
        var availabilityZoneRelocation: Boolean?
        /**
         * The identifier of the cluster that will be created from restoring the
         * snapshot.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         */
        var clusterIdentifier: String?
        /**
         * The name of the parameter group to be associated with this cluster.
         * Default: The default Amazon Redshift cluster parameter group. For information about the
         * default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
         * Redshift Parameter Groups.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var clusterParameterGroupName: String?
        /**
         * A list of security groups to be associated with this cluster.
         * Default: The default cluster security group for Amazon Redshift.
         * Cluster security groups only apply to clusters outside of VPCs.
         */
        var clusterSecurityGroups: List<String>?
        /**
         * The name of the subnet group where you want to cluster restored.
         * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
         * provide subnet group name where you want the cluster restored.
         */
        var clusterSubnetGroupName: String?
        /**
         * The elastic IP (EIP) address for the cluster.
         */
        var elasticIp: String?
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        var enhancedVpcRouting: Boolean?
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        var hsmClientCertificateIdentifier: String?
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        var hsmConfigurationIdentifier: String?
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the
         * cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
         * Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
         * request.
         * A cluster can have up to 10 IAM roles associated at any time.
         */
        var iamRoles: List<String>?
        /**
         * The Key Management Service (KMS) key ID of the encryption key that you want to
         * use to encrypt data in the cluster that you restore from a shared snapshot.
         */
        var kmsKeyId: String?
        /**
         * The name of the maintenance track for the restored cluster. When you take a snapshot,
         * the snapshot inherits the MaintenanceTrack value from the cluster. The
         * snapshot might be on a different track than the cluster that was the source for the
         * snapshot. For example, suppose that you take a snapshot of a cluster that is on the
         * current track and then change the cluster to be on the trailing track. In this case, the
         * snapshot and the source cluster are on different tracks.
         */
        var maintenanceTrackName: String?
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the
         * snapshot is retained indefinitely. This setting doesn't change the retention period
         * of existing snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * The node type that the restored cluster will be provisioned with.
         * Default: The node type of the cluster from which the snapshot was taken. You can
         * modify this if you are using any DS node type. In that case, you can choose to restore
         * into another DS node type of the same size. For example, you can restore ds1.8xlarge
         * into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
         * must restore into that same instance type and size. In other words, you can only restore
         * a dc1.large instance type into another dc1.large instance type or dc2.large instance
         * type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
         * cluster, then resize to a dc2.8large cluster. For more information about node types, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
         * About Clusters and Nodes in the Amazon Redshift Cluster Management Guide.
         */
        var nodeType: String?
        /**
         * The number of nodes specified when provisioning the restored cluster.
         */
        var numberOfNodes: Int?
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are
         * restoring a snapshot you do not own, optional if you own the snapshot.
         */
        var ownerAccount: String?
        /**
         * The port number on which the cluster accepts connections.
         * Default: The same port as the original cluster.
         * Constraints: Must be between 1115 and 65535.
         */
        var port: Int?
        /**
         * The weekly time range (in UTC) during which automated cluster maintenance can
         * occur.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * Default: The value selected for the cluster from which the snapshot was taken. For
         * more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows in Amazon Redshift Cluster Management Guide.
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: String?
        /**
         * If true, the cluster can be accessed from a public network.
         */
        var publiclyAccessible: Boolean?
        /**
         * The name of the cluster the source snapshot was created from. This parameter is
         * required if your IAM user has a policy containing a snapshot resource element that
         * specifies anything other than * for the cluster name.
         */
        var snapshotClusterIdentifier: String?
        /**
         * The name of the snapshot from which to create the new cluster. This parameter isn't
         * case sensitive.
         * Example: my-snapshot-id
         */
        var snapshotIdentifier: String?
        /**
         * A unique identifier for the snapshot schedule.
         */
        var snapshotScheduleIdentifier: String?
        /**
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the
         * cluster.
         * Default: The default VPC security group is associated with the cluster.
         * VPC security groups only apply to clusters in VPCs.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): RestoreFromClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalInfo: String? = null
        override var allowVersionUpgrade: Boolean? = null
        override var aquaConfigurationStatus: AquaConfigurationStatus? = null
        override var automatedSnapshotRetentionPeriod: Int? = null
        override var availabilityZone: String? = null
        override var availabilityZoneRelocation: Boolean? = null
        override var clusterIdentifier: String? = null
        override var clusterParameterGroupName: String? = null
        override var clusterSecurityGroups: List<String>? = null
        override var clusterSubnetGroupName: String? = null
        override var elasticIp: String? = null
        override var enhancedVpcRouting: Boolean? = null
        override var hsmClientCertificateIdentifier: String? = null
        override var hsmConfigurationIdentifier: String? = null
        override var iamRoles: List<String>? = null
        override var kmsKeyId: String? = null
        override var maintenanceTrackName: String? = null
        override var manualSnapshotRetentionPeriod: Int? = null
        override var nodeType: String? = null
        override var numberOfNodes: Int? = null
        override var ownerAccount: String? = null
        override var port: Int? = null
        override var preferredMaintenanceWindow: String? = null
        override var publiclyAccessible: Boolean? = null
        override var snapshotClusterIdentifier: String? = null
        override var snapshotIdentifier: String? = null
        override var snapshotScheduleIdentifier: String? = null
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: RestoreFromClusterSnapshotRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.aquaConfigurationStatus = x.aquaConfigurationStatus
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocation = x.availabilityZoneRelocation
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterParameterGroupName = x.clusterParameterGroupName
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.elasticIp = x.elasticIp
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.ownerAccount = x.ownerAccount
            this.port = x.port
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.snapshotClusterIdentifier = x.snapshotClusterIdentifier
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): RestoreFromClusterSnapshotRequest = RestoreFromClusterSnapshotRequest(this)
        override fun additionalInfo(additionalInfo: String): FluentBuilder = apply { this.additionalInfo = additionalInfo }
        override fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder = apply { this.allowVersionUpgrade = allowVersionUpgrade }
        override fun aquaConfigurationStatus(aquaConfigurationStatus: AquaConfigurationStatus): FluentBuilder = apply { this.aquaConfigurationStatus = aquaConfigurationStatus }
        override fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneRelocation(availabilityZoneRelocation: Boolean): FluentBuilder = apply { this.availabilityZoneRelocation = availabilityZoneRelocation }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterParameterGroupName(clusterParameterGroupName: String): FluentBuilder = apply { this.clusterParameterGroupName = clusterParameterGroupName }
        override fun clusterSecurityGroups(clusterSecurityGroups: List<String>): FluentBuilder = apply { this.clusterSecurityGroups = clusterSecurityGroups }
        override fun clusterSubnetGroupName(clusterSubnetGroupName: String): FluentBuilder = apply { this.clusterSubnetGroupName = clusterSubnetGroupName }
        override fun elasticIp(elasticIp: String): FluentBuilder = apply { this.elasticIp = elasticIp }
        override fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder = apply { this.enhancedVpcRouting = enhancedVpcRouting }
        override fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder = apply { this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier }
        override fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder = apply { this.hsmConfigurationIdentifier = hsmConfigurationIdentifier }
        override fun iamRoles(iamRoles: List<String>): FluentBuilder = apply { this.iamRoles = iamRoles }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun numberOfNodes(numberOfNodes: Int): FluentBuilder = apply { this.numberOfNodes = numberOfNodes }
        override fun ownerAccount(ownerAccount: String): FluentBuilder = apply { this.ownerAccount = ownerAccount }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
        override fun snapshotClusterIdentifier(snapshotClusterIdentifier: String): FluentBuilder = apply { this.snapshotClusterIdentifier = snapshotClusterIdentifier }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun snapshotScheduleIdentifier(snapshotScheduleIdentifier: String): FluentBuilder = apply { this.snapshotScheduleIdentifier = snapshotScheduleIdentifier }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
