// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a reserved node offering.
 */
class ReservedNodeOffering private constructor(builder: BuilderImpl) {
    /**
     * The currency code for the compute nodes offering.
     */
    val currencyCode: String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the offering will reserve the node.
     */
    val duration: Int = builder.duration
    /**
     * The upfront fixed charge you will pay to purchase the specific reserved node
     * offering.
     */
    val fixedPrice: Double = builder.fixedPrice
    /**
     * The node type offered by the reserved node offering.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The anticipated utilization of the reserved node, as defined in the reserved node
     * offering.
     */
    val offeringType: String? = builder.offeringType
    /**
     * The charge to your account regardless of whether you are creating any clusters
     * using the node offering. Recurring charges are only in effect for heavy-utilization
     * reserved nodes.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The offering identifier.
     */
    val reservedNodeOfferingId: String? = builder.reservedNodeOfferingId
    /**
     *
     */
    val reservedNodeOfferingType: ReservedNodeOfferingType? = builder.reservedNodeOfferingType
    /**
     * The rate you are charged for each hour the cluster that is using the offering is
     * running.
     */
    val usagePrice: Double = builder.usagePrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedNodeOffering = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedNodeOffering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("nodeType=$nodeType,")
        append("offeringType=$offeringType,")
        append("recurringCharges=$recurringCharges,")
        append("reservedNodeOfferingId=$reservedNodeOfferingId,")
        append("reservedNodeOfferingType=$reservedNodeOfferingType,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice.hashCode())
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingType?.hashCode() ?: 0)
        result = 31 * result + (usagePrice.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedNodeOffering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (nodeType != other.nodeType) return false
        if (offeringType != other.offeringType) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedNodeOfferingId != other.reservedNodeOfferingId) return false
        if (reservedNodeOfferingType != other.reservedNodeOfferingType) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedNodeOffering = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedNodeOffering
        /**
         * The currency code for the compute nodes offering.
         */
        fun currencyCode(currencyCode: String): FluentBuilder
        /**
         * The duration, in seconds, for which the offering will reserve the node.
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The upfront fixed charge you will pay to purchase the specific reserved node
         * offering.
         */
        fun fixedPrice(fixedPrice: Double): FluentBuilder
        /**
         * The node type offered by the reserved node offering.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node
         * offering.
         */
        fun offeringType(offeringType: String): FluentBuilder
        /**
         * The charge to your account regardless of whether you are creating any clusters
         * using the node offering. Recurring charges are only in effect for heavy-utilization
         * reserved nodes.
         */
        fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder
        /**
         * The offering identifier.
         */
        fun reservedNodeOfferingId(reservedNodeOfferingId: String): FluentBuilder
        /**
         *
         */
        fun reservedNodeOfferingType(reservedNodeOfferingType: ReservedNodeOfferingType): FluentBuilder
        /**
         * The rate you are charged for each hour the cluster that is using the offering is
         * running.
         */
        fun usagePrice(usagePrice: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The currency code for the compute nodes offering.
         */
        var currencyCode: String?
        /**
         * The duration, in seconds, for which the offering will reserve the node.
         */
        var duration: Int
        /**
         * The upfront fixed charge you will pay to purchase the specific reserved node
         * offering.
         */
        var fixedPrice: Double
        /**
         * The node type offered by the reserved node offering.
         */
        var nodeType: String?
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node
         * offering.
         */
        var offeringType: String?
        /**
         * The charge to your account regardless of whether you are creating any clusters
         * using the node offering. Recurring charges are only in effect for heavy-utilization
         * reserved nodes.
         */
        var recurringCharges: List<RecurringCharge>?
        /**
         * The offering identifier.
         */
        var reservedNodeOfferingId: String?
        /**
         *
         */
        var reservedNodeOfferingType: ReservedNodeOfferingType?
        /**
         * The rate you are charged for each hour the cluster that is using the offering is
         * running.
         */
        var usagePrice: Double

        fun build(): ReservedNodeOffering
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: String? = null
        override var duration: Int = 0
        override var fixedPrice: Double = 0.0
        override var nodeType: String? = null
        override var offeringType: String? = null
        override var recurringCharges: List<RecurringCharge>? = null
        override var reservedNodeOfferingId: String? = null
        override var reservedNodeOfferingType: ReservedNodeOfferingType? = null
        override var usagePrice: Double = 0.0

        constructor(x: ReservedNodeOffering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.nodeType = x.nodeType
            this.offeringType = x.offeringType
            this.recurringCharges = x.recurringCharges
            this.reservedNodeOfferingId = x.reservedNodeOfferingId
            this.reservedNodeOfferingType = x.reservedNodeOfferingType
            this.usagePrice = x.usagePrice
        }

        override fun build(): ReservedNodeOffering = ReservedNodeOffering(this)
        override fun currencyCode(currencyCode: String): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun fixedPrice(fixedPrice: Double): FluentBuilder = apply { this.fixedPrice = fixedPrice }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun offeringType(offeringType: String): FluentBuilder = apply { this.offeringType = offeringType }
        override fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder = apply { this.recurringCharges = recurringCharges }
        override fun reservedNodeOfferingId(reservedNodeOfferingId: String): FluentBuilder = apply { this.reservedNodeOfferingId = reservedNodeOfferingId }
        override fun reservedNodeOfferingType(reservedNodeOfferingType: ReservedNodeOfferingType): FluentBuilder = apply { this.reservedNodeOfferingType = reservedNodeOfferingType }
        override fun usagePrice(usagePrice: Double): FluentBuilder = apply { this.usagePrice = usagePrice }
    }
}
