// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a reserved node. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node
 * offerings.
 */
class ReservedNode private constructor(builder: BuilderImpl) {
    /**
     * The currency code for the reserved cluster.
     */
    val currencyCode: String? = builder.currencyCode
    /**
     * The duration of the node reservation in seconds.
     */
    val duration: Int = builder.duration
    /**
     * The fixed cost Amazon Redshift charges you for this reserved node.
     */
    val fixedPrice: Double = builder.fixedPrice
    /**
     * The number of reserved compute nodes.
     */
    val nodeCount: Int = builder.nodeCount
    /**
     * The node type of the reserved node.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The anticipated utilization of the reserved node, as defined in the reserved node
     * offering.
     */
    val offeringType: String? = builder.offeringType
    /**
     * The recurring charges for the reserved node.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The unique identifier for the reservation.
     */
    val reservedNodeId: String? = builder.reservedNodeId
    /**
     * The identifier for the reserved node offering.
     */
    val reservedNodeOfferingId: String? = builder.reservedNodeOfferingId
    /**
     *
     */
    val reservedNodeOfferingType: ReservedNodeOfferingType? = builder.reservedNodeOfferingType
    /**
     * The time the reservation started. You purchase a reserved node offering for a
     * duration. This is the start time of that duration.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The state of the reserved compute node.
     * Possible Values:
     * pending-payment-This reserved node has recently been purchased, and the
     * sale has been approved, but payment has not yet been confirmed.
     * active-This reserved node is owned by the caller and is available for
     * use.
     * payment-failed-Payment failed for the purchase attempt.
     * retired-The reserved node is no longer available.
     * exchanging-The owner is exchanging the reserved node for another reserved
     * node.
     */
    val state: String? = builder.state
    /**
     * The hourly rate Amazon Redshift charges you for this reserved node.
     */
    val usagePrice: Double = builder.usagePrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReservedNode = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedNode(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("nodeCount=$nodeCount,")
        append("nodeType=$nodeType,")
        append("offeringType=$offeringType,")
        append("recurringCharges=$recurringCharges,")
        append("reservedNodeId=$reservedNodeId,")
        append("reservedNodeOfferingId=$reservedNodeOfferingId,")
        append("reservedNodeOfferingType=$reservedNodeOfferingType,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice.hashCode())
        result = 31 * result + (nodeCount)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReservedNode

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (nodeCount != other.nodeCount) return false
        if (nodeType != other.nodeType) return false
        if (offeringType != other.offeringType) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedNodeId != other.reservedNodeId) return false
        if (reservedNodeOfferingId != other.reservedNodeOfferingId) return false
        if (reservedNodeOfferingType != other.reservedNodeOfferingType) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReservedNode = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReservedNode
        /**
         * The currency code for the reserved cluster.
         */
        fun currencyCode(currencyCode: String): FluentBuilder
        /**
         * The duration of the node reservation in seconds.
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The fixed cost Amazon Redshift charges you for this reserved node.
         */
        fun fixedPrice(fixedPrice: Double): FluentBuilder
        /**
         * The number of reserved compute nodes.
         */
        fun nodeCount(nodeCount: Int): FluentBuilder
        /**
         * The node type of the reserved node.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node
         * offering.
         */
        fun offeringType(offeringType: String): FluentBuilder
        /**
         * The recurring charges for the reserved node.
         */
        fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder
        /**
         * The unique identifier for the reservation.
         */
        fun reservedNodeId(reservedNodeId: String): FluentBuilder
        /**
         * The identifier for the reserved node offering.
         */
        fun reservedNodeOfferingId(reservedNodeOfferingId: String): FluentBuilder
        /**
         *
         */
        fun reservedNodeOfferingType(reservedNodeOfferingType: ReservedNodeOfferingType): FluentBuilder
        /**
         * The time the reservation started. You purchase a reserved node offering for a
         * duration. This is the start time of that duration.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The state of the reserved compute node.
         * Possible Values:
         * pending-payment-This reserved node has recently been purchased, and the
         * sale has been approved, but payment has not yet been confirmed.
         * active-This reserved node is owned by the caller and is available for
         * use.
         * payment-failed-Payment failed for the purchase attempt.
         * retired-The reserved node is no longer available.
         * exchanging-The owner is exchanging the reserved node for another reserved
         * node.
         */
        fun state(state: String): FluentBuilder
        /**
         * The hourly rate Amazon Redshift charges you for this reserved node.
         */
        fun usagePrice(usagePrice: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The currency code for the reserved cluster.
         */
        var currencyCode: String?
        /**
         * The duration of the node reservation in seconds.
         */
        var duration: Int
        /**
         * The fixed cost Amazon Redshift charges you for this reserved node.
         */
        var fixedPrice: Double
        /**
         * The number of reserved compute nodes.
         */
        var nodeCount: Int
        /**
         * The node type of the reserved node.
         */
        var nodeType: String?
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node
         * offering.
         */
        var offeringType: String?
        /**
         * The recurring charges for the reserved node.
         */
        var recurringCharges: List<RecurringCharge>?
        /**
         * The unique identifier for the reservation.
         */
        var reservedNodeId: String?
        /**
         * The identifier for the reserved node offering.
         */
        var reservedNodeOfferingId: String?
        /**
         *
         */
        var reservedNodeOfferingType: ReservedNodeOfferingType?
        /**
         * The time the reservation started. You purchase a reserved node offering for a
         * duration. This is the start time of that duration.
         */
        var startTime: Instant?
        /**
         * The state of the reserved compute node.
         * Possible Values:
         * pending-payment-This reserved node has recently been purchased, and the
         * sale has been approved, but payment has not yet been confirmed.
         * active-This reserved node is owned by the caller and is available for
         * use.
         * payment-failed-Payment failed for the purchase attempt.
         * retired-The reserved node is no longer available.
         * exchanging-The owner is exchanging the reserved node for another reserved
         * node.
         */
        var state: String?
        /**
         * The hourly rate Amazon Redshift charges you for this reserved node.
         */
        var usagePrice: Double

        fun build(): ReservedNode
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: String? = null
        override var duration: Int = 0
        override var fixedPrice: Double = 0.0
        override var nodeCount: Int = 0
        override var nodeType: String? = null
        override var offeringType: String? = null
        override var recurringCharges: List<RecurringCharge>? = null
        override var reservedNodeId: String? = null
        override var reservedNodeOfferingId: String? = null
        override var reservedNodeOfferingType: ReservedNodeOfferingType? = null
        override var startTime: Instant? = null
        override var state: String? = null
        override var usagePrice: Double = 0.0

        constructor(x: ReservedNode) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.nodeCount = x.nodeCount
            this.nodeType = x.nodeType
            this.offeringType = x.offeringType
            this.recurringCharges = x.recurringCharges
            this.reservedNodeId = x.reservedNodeId
            this.reservedNodeOfferingId = x.reservedNodeOfferingId
            this.reservedNodeOfferingType = x.reservedNodeOfferingType
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        override fun build(): ReservedNode = ReservedNode(this)
        override fun currencyCode(currencyCode: String): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun fixedPrice(fixedPrice: Double): FluentBuilder = apply { this.fixedPrice = fixedPrice }
        override fun nodeCount(nodeCount: Int): FluentBuilder = apply { this.nodeCount = nodeCount }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun offeringType(offeringType: String): FluentBuilder = apply { this.offeringType = offeringType }
        override fun recurringCharges(recurringCharges: List<RecurringCharge>): FluentBuilder = apply { this.recurringCharges = recurringCharges }
        override fun reservedNodeId(reservedNodeId: String): FluentBuilder = apply { this.reservedNodeId = reservedNodeId }
        override fun reservedNodeOfferingId(reservedNodeOfferingId: String): FluentBuilder = apply { this.reservedNodeOfferingId = reservedNodeOfferingId }
        override fun reservedNodeOfferingType(reservedNodeOfferingType: ReservedNodeOfferingType): FluentBuilder = apply { this.reservedNodeOfferingType = reservedNodeOfferingType }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun usagePrice(usagePrice: Double): FluentBuilder = apply { this.usagePrice = usagePrice }
    }
}
