// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class RejectDataShareResponse private constructor(builder: BuilderImpl) {
    /**
     * A value that specifies whether the datashare can be shared to a publicly accessible  cluster.
     */
    val allowPubliclyAccessibleConsumers: Boolean = builder.allowPubliclyAccessibleConsumers
    /**
     * An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name} format.
     */
    val dataShareArn: String? = builder.dataShareArn
    /**
     * A value that specifies when the datashare has an association between a producer and data consumers.
     */
    val dataShareAssociations: List<DataShareAssociation>? = builder.dataShareAssociations
    /**
     * The Amazon Resource Name (ARN) of the producer.
     */
    val producerArn: String? = builder.producerArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RejectDataShareResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RejectDataShareResponse(")
        append("allowPubliclyAccessibleConsumers=$allowPubliclyAccessibleConsumers,")
        append("dataShareArn=$dataShareArn,")
        append("dataShareAssociations=$dataShareAssociations,")
        append("producerArn=$producerArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowPubliclyAccessibleConsumers.hashCode()
        result = 31 * result + (dataShareArn?.hashCode() ?: 0)
        result = 31 * result + (dataShareAssociations?.hashCode() ?: 0)
        result = 31 * result + (producerArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RejectDataShareResponse

        if (allowPubliclyAccessibleConsumers != other.allowPubliclyAccessibleConsumers) return false
        if (dataShareArn != other.dataShareArn) return false
        if (dataShareAssociations != other.dataShareAssociations) return false
        if (producerArn != other.producerArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RejectDataShareResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RejectDataShareResponse
        /**
         * A value that specifies whether the datashare can be shared to a publicly accessible  cluster.
         */
        fun allowPubliclyAccessibleConsumers(allowPubliclyAccessibleConsumers: Boolean): FluentBuilder
        /**
         * An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name} format.
         */
        fun dataShareArn(dataShareArn: String): FluentBuilder
        /**
         * A value that specifies when the datashare has an association between a producer and data consumers.
         */
        fun dataShareAssociations(dataShareAssociations: List<DataShareAssociation>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the producer.
         */
        fun producerArn(producerArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that specifies whether the datashare can be shared to a publicly accessible  cluster.
         */
        var allowPubliclyAccessibleConsumers: Boolean
        /**
         * An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name} format.
         */
        var dataShareArn: String?
        /**
         * A value that specifies when the datashare has an association between a producer and data consumers.
         */
        var dataShareAssociations: List<DataShareAssociation>?
        /**
         * The Amazon Resource Name (ARN) of the producer.
         */
        var producerArn: String?

        fun build(): RejectDataShareResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowPubliclyAccessibleConsumers: Boolean = false
        override var dataShareArn: String? = null
        override var dataShareAssociations: List<DataShareAssociation>? = null
        override var producerArn: String? = null

        constructor(x: RejectDataShareResponse) : this() {
            this.allowPubliclyAccessibleConsumers = x.allowPubliclyAccessibleConsumers
            this.dataShareArn = x.dataShareArn
            this.dataShareAssociations = x.dataShareAssociations
            this.producerArn = x.producerArn
        }

        override fun build(): RejectDataShareResponse = RejectDataShareResponse(this)
        override fun allowPubliclyAccessibleConsumers(allowPubliclyAccessibleConsumers: Boolean): FluentBuilder = apply { this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers }
        override fun dataShareArn(dataShareArn: String): FluentBuilder = apply { this.dataShareArn = dataShareArn }
        override fun dataShareAssociations(dataShareAssociations: List<DataShareAssociation>): FluentBuilder = apply { this.dataShareAssociations = dataShareAssociations }
        override fun producerArn(producerArn: String): FluentBuilder = apply { this.producerArn = producerArn }
    }
}
