// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes cluster attributes that are in a pending state. A change to one or more
 * the attributes was requested and is in progress or will be applied.
 */
class PendingModifiedValues private constructor(builder: BuilderImpl) {
    /**
     * The pending or in-progress change of the automated snapshot retention
     * period.
     */
    val automatedSnapshotRetentionPeriod: Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The pending or in-progress change of the new identifier for the cluster.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The pending or in-progress change of the cluster type.
     */
    val clusterType: String? = builder.clusterType
    /**
     * The pending or in-progress change of the service version.
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     * The encryption type for a cluster. Possible values are: KMS and None.
     */
    val encryptionType: String? = builder.encryptionType
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing
     * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
     * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
     * the Amazon Redshift Cluster Management Guide.
     * If this option is true, enhanced VPC routing is enabled.
     * Default: false
     */
    val enhancedVpcRouting: Boolean? = builder.enhancedVpcRouting
    /**
     * The name of the maintenance track that the cluster will change to during the next
     * maintenance window.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * The pending or in-progress change of the admin user password for the
     * cluster.
     */
    val masterUserPassword: String? = builder.masterUserPassword
    /**
     * The pending or in-progress change of the cluster's node type.
     */
    val nodeType: String? = builder.nodeType
    /**
     * The pending or in-progress change of the number of nodes in the cluster.
     */
    val numberOfNodes: Int? = builder.numberOfNodes
    /**
     * The pending or in-progress change of the ability to connect to the cluster from the
     * public network.
     */
    val publiclyAccessible: Boolean? = builder.publiclyAccessible

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PendingModifiedValues = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterType=$clusterType,")
        append("clusterVersion=$clusterVersion,")
        append("encryptionType=$encryptionType,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("masterUserPassword=$masterUserPassword,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("publiclyAccessible=$publiclyAccessible)")
    }

    override fun hashCode(): kotlin.Int {
        var result = automatedSnapshotRetentionPeriod ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PendingModifiedValues

        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterType != other.clusterType) return false
        if (clusterVersion != other.clusterVersion) return false
        if (encryptionType != other.encryptionType) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (publiclyAccessible != other.publiclyAccessible) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PendingModifiedValues = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PendingModifiedValues
        /**
         * The pending or in-progress change of the automated snapshot retention
         * period.
         */
        fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The pending or in-progress change of the new identifier for the cluster.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The pending or in-progress change of the cluster type.
         */
        fun clusterType(clusterType: String): FluentBuilder
        /**
         * The pending or in-progress change of the service version.
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         * The encryption type for a cluster. Possible values are: KMS and None.
         */
        fun encryptionType(encryptionType: String): FluentBuilder
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder
        /**
         * The name of the maintenance track that the cluster will change to during the next
         * maintenance window.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * The pending or in-progress change of the admin user password for the
         * cluster.
         */
        fun masterUserPassword(masterUserPassword: String): FluentBuilder
        /**
         * The pending or in-progress change of the cluster's node type.
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The pending or in-progress change of the number of nodes in the cluster.
         */
        fun numberOfNodes(numberOfNodes: Int): FluentBuilder
        /**
         * The pending or in-progress change of the ability to connect to the cluster from the
         * public network.
         */
        fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The pending or in-progress change of the automated snapshot retention
         * period.
         */
        var automatedSnapshotRetentionPeriod: Int?
        /**
         * The pending or in-progress change of the new identifier for the cluster.
         */
        var clusterIdentifier: String?
        /**
         * The pending or in-progress change of the cluster type.
         */
        var clusterType: String?
        /**
         * The pending or in-progress change of the service version.
         */
        var clusterVersion: String?
        /**
         * The encryption type for a cluster. Possible values are: KMS and None.
         */
        var encryptionType: String?
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        var enhancedVpcRouting: Boolean?
        /**
         * The name of the maintenance track that the cluster will change to during the next
         * maintenance window.
         */
        var maintenanceTrackName: String?
        /**
         * The pending or in-progress change of the admin user password for the
         * cluster.
         */
        var masterUserPassword: String?
        /**
         * The pending or in-progress change of the cluster's node type.
         */
        var nodeType: String?
        /**
         * The pending or in-progress change of the number of nodes in the cluster.
         */
        var numberOfNodes: Int?
        /**
         * The pending or in-progress change of the ability to connect to the cluster from the
         * public network.
         */
        var publiclyAccessible: Boolean?

        fun build(): PendingModifiedValues
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var automatedSnapshotRetentionPeriod: Int? = null
        override var clusterIdentifier: String? = null
        override var clusterType: String? = null
        override var clusterVersion: String? = null
        override var encryptionType: String? = null
        override var enhancedVpcRouting: Boolean? = null
        override var maintenanceTrackName: String? = null
        override var masterUserPassword: String? = null
        override var nodeType: String? = null
        override var numberOfNodes: Int? = null
        override var publiclyAccessible: Boolean? = null

        constructor(x: PendingModifiedValues) : this() {
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterType = x.clusterType
            this.clusterVersion = x.clusterVersion
            this.encryptionType = x.encryptionType
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.maintenanceTrackName = x.maintenanceTrackName
            this.masterUserPassword = x.masterUserPassword
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.publiclyAccessible = x.publiclyAccessible
        }

        override fun build(): PendingModifiedValues = PendingModifiedValues(this)
        override fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterType(clusterType: String): FluentBuilder = apply { this.clusterType = clusterType }
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun encryptionType(encryptionType: String): FluentBuilder = apply { this.encryptionType = encryptionType }
        override fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder = apply { this.enhancedVpcRouting = enhancedVpcRouting }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun masterUserPassword(masterUserPassword: String): FluentBuilder = apply { this.masterUserPassword = masterUserPassword }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun numberOfNodes(numberOfNodes: Int): FluentBuilder = apply { this.numberOfNodes = numberOfNodes }
        override fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
    }
}
