// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a partner integration.
 */
class PartnerIntegrationInfo private constructor(builder: BuilderImpl) {
    /**
     * The date (UTC) that the partner integration was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The name of the database that receives data from a partner.
     */
    val databaseName: String? = builder.databaseName
    /**
     * The name of the partner.
     */
    val partnerName: String? = builder.partnerName
    /**
     * The partner integration status.
     */
    val status: PartnerIntegrationStatus? = builder.status
    /**
     * The status message provided by the partner.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The date (UTC) that the partner integration status was last updated by the partner.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PartnerIntegrationInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PartnerIntegrationInfo(")
        append("createdAt=$createdAt,")
        append("databaseName=$databaseName,")
        append("partnerName=$partnerName,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (partnerName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PartnerIntegrationInfo

        if (createdAt != other.createdAt) return false
        if (databaseName != other.databaseName) return false
        if (partnerName != other.partnerName) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PartnerIntegrationInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PartnerIntegrationInfo
        /**
         * The date (UTC) that the partner integration was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The name of the database that receives data from a partner.
         */
        fun databaseName(databaseName: String): FluentBuilder
        /**
         * The name of the partner.
         */
        fun partnerName(partnerName: String): FluentBuilder
        /**
         * The partner integration status.
         */
        fun status(status: PartnerIntegrationStatus): FluentBuilder
        /**
         * The status message provided by the partner.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The date (UTC) that the partner integration status was last updated by the partner.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date (UTC) that the partner integration was created.
         */
        var createdAt: Instant?
        /**
         * The name of the database that receives data from a partner.
         */
        var databaseName: String?
        /**
         * The name of the partner.
         */
        var partnerName: String?
        /**
         * The partner integration status.
         */
        var status: PartnerIntegrationStatus?
        /**
         * The status message provided by the partner.
         */
        var statusMessage: String?
        /**
         * The date (UTC) that the partner integration status was last updated by the partner.
         */
        var updatedAt: Instant?

        fun build(): PartnerIntegrationInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdAt: Instant? = null
        override var databaseName: String? = null
        override var partnerName: String? = null
        override var status: PartnerIntegrationStatus? = null
        override var statusMessage: String? = null
        override var updatedAt: Instant? = null

        constructor(x: PartnerIntegrationInfo) : this() {
            this.createdAt = x.createdAt
            this.databaseName = x.databaseName
            this.partnerName = x.partnerName
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.updatedAt = x.updatedAt
        }

        override fun build(): PartnerIntegrationInfo = PartnerIntegrationInfo(this)
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun databaseName(databaseName: String): FluentBuilder = apply { this.databaseName = databaseName }
        override fun partnerName(partnerName: String): FluentBuilder = apply { this.partnerName = partnerName }
        override fun status(status: PartnerIntegrationStatus): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
