// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a parameter in a cluster parameter group.
 */
class Parameter private constructor(builder: BuilderImpl) {
    /**
     * The valid range of values for the parameter.
     */
    val allowedValues: String? = builder.allowedValues
    /**
     * Specifies how to apply the WLM configuration parameter. Some properties can be
     * applied dynamically, while other properties require that any associated clusters be
     * rebooted for the configuration changes to be applied.
     * For more information about parameters and parameter groups, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
     * in the Amazon Redshift Cluster Management Guide.
     */
    val applyType: ParameterApplyType? = builder.applyType
    /**
     * The data type of the parameter.
     */
    val dataType: String? = builder.dataType
    /**
     * A description of the parameter.
     */
    val description: String? = builder.description
    /**
     * If true, the parameter can be modified. Some parameters have security
     * or operational implications that prevent them from being changed.
     */
    val isModifiable: Boolean = builder.isModifiable
    /**
     * The earliest engine version to which the parameter can apply.
     */
    val minimumEngineVersion: String? = builder.minimumEngineVersion
    /**
     * The name of the parameter.
     */
    val parameterName: String? = builder.parameterName
    /**
     * The value of the parameter. If ParameterName is wlm_json_configuration,
     * then the maximum size of ParameterValue is 8000 characters.
     */
    val parameterValue: String? = builder.parameterValue
    /**
     * The source of the parameter value, such as "engine-default" or "user".
     */
    val source: String? = builder.source

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Parameter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("applyType=$applyType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("parameterValue=$parameterValue,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (applyType != other.applyType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Parameter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Parameter
        /**
         * The valid range of values for the parameter.
         */
        fun allowedValues(allowedValues: String): FluentBuilder
        /**
         * Specifies how to apply the WLM configuration parameter. Some properties can be
         * applied dynamically, while other properties require that any associated clusters be
         * rebooted for the configuration changes to be applied.
         * For more information about parameters and parameter groups, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
         * in the Amazon Redshift Cluster Management Guide.
         */
        fun applyType(applyType: ParameterApplyType): FluentBuilder
        /**
         * The data type of the parameter.
         */
        fun dataType(dataType: String): FluentBuilder
        /**
         * A description of the parameter.
         */
        fun description(description: String): FluentBuilder
        /**
         * If true, the parameter can be modified. Some parameters have security
         * or operational implications that prevent them from being changed.
         */
        fun isModifiable(isModifiable: Boolean): FluentBuilder
        /**
         * The earliest engine version to which the parameter can apply.
         */
        fun minimumEngineVersion(minimumEngineVersion: String): FluentBuilder
        /**
         * The name of the parameter.
         */
        fun parameterName(parameterName: String): FluentBuilder
        /**
         * The value of the parameter. If ParameterName is wlm_json_configuration,
         * then the maximum size of ParameterValue is 8000 characters.
         */
        fun parameterValue(parameterValue: String): FluentBuilder
        /**
         * The source of the parameter value, such as "engine-default" or "user".
         */
        fun source(source: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The valid range of values for the parameter.
         */
        var allowedValues: String?
        /**
         * Specifies how to apply the WLM configuration parameter. Some properties can be
         * applied dynamically, while other properties require that any associated clusters be
         * rebooted for the configuration changes to be applied.
         * For more information about parameters and parameter groups, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
         * in the Amazon Redshift Cluster Management Guide.
         */
        var applyType: ParameterApplyType?
        /**
         * The data type of the parameter.
         */
        var dataType: String?
        /**
         * A description of the parameter.
         */
        var description: String?
        /**
         * If true, the parameter can be modified. Some parameters have security
         * or operational implications that prevent them from being changed.
         */
        var isModifiable: Boolean
        /**
         * The earliest engine version to which the parameter can apply.
         */
        var minimumEngineVersion: String?
        /**
         * The name of the parameter.
         */
        var parameterName: String?
        /**
         * The value of the parameter. If ParameterName is wlm_json_configuration,
         * then the maximum size of ParameterValue is 8000 characters.
         */
        var parameterValue: String?
        /**
         * The source of the parameter value, such as "engine-default" or "user".
         */
        var source: String?

        fun build(): Parameter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowedValues: String? = null
        override var applyType: ParameterApplyType? = null
        override var dataType: String? = null
        override var description: String? = null
        override var isModifiable: Boolean = false
        override var minimumEngineVersion: String? = null
        override var parameterName: String? = null
        override var parameterValue: String? = null
        override var source: String? = null

        constructor(x: Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.applyType = x.applyType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.parameterValue = x.parameterValue
            this.source = x.source
        }

        override fun build(): Parameter = Parameter(this)
        override fun allowedValues(allowedValues: String): FluentBuilder = apply { this.allowedValues = allowedValues }
        override fun applyType(applyType: ParameterApplyType): FluentBuilder = apply { this.applyType = applyType }
        override fun dataType(dataType: String): FluentBuilder = apply { this.dataType = dataType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun isModifiable(isModifiable: Boolean): FluentBuilder = apply { this.isModifiable = isModifiable }
        override fun minimumEngineVersion(minimumEngineVersion: String): FluentBuilder = apply { this.minimumEngineVersion = minimumEngineVersion }
        override fun parameterName(parameterName: String): FluentBuilder = apply { this.parameterName = parameterName }
        override fun parameterValue(parameterValue: String): FluentBuilder = apply { this.parameterValue = parameterValue }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
    }
}
