// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * A set of elements to filter the returned node configurations.
 */
class NodeConfigurationOptionsFilter private constructor(builder: BuilderImpl) {
    /**
     * The name of the element to filter.
     */
    val name: NodeConfigurationOptionsFilterName? = builder.name
    /**
     * The filter operator.
     * If filter Name is NodeType only the 'in' operator is supported.
     * Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'.
     * Provide two values to evaluate for 'between'.
     * Provide a list of values for 'in'.
     */
    val operator: OperatorType? = builder.operator
    /**
     * List of values. Compare Name using Operator to Values.
     * If filter Name is NumberOfNodes, then values can range from 0 to 200.
     * If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100.
     * For example, filter NumberOfNodes (name) GT (operator) 3 (values).
     */
    val values: List<String>? = builder.values

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NodeConfigurationOptionsFilter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NodeConfigurationOptionsFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NodeConfigurationOptionsFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NodeConfigurationOptionsFilter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NodeConfigurationOptionsFilter
        /**
         * The name of the element to filter.
         */
        fun name(name: NodeConfigurationOptionsFilterName): FluentBuilder
        /**
         * The filter operator.
         * If filter Name is NodeType only the 'in' operator is supported.
         * Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'.
         * Provide two values to evaluate for 'between'.
         * Provide a list of values for 'in'.
         */
        fun operator(operator: OperatorType): FluentBuilder
        /**
         * List of values. Compare Name using Operator to Values.
         * If filter Name is NumberOfNodes, then values can range from 0 to 200.
         * If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100.
         * For example, filter NumberOfNodes (name) GT (operator) 3 (values).
         */
        fun values(values: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the element to filter.
         */
        var name: NodeConfigurationOptionsFilterName?
        /**
         * The filter operator.
         * If filter Name is NodeType only the 'in' operator is supported.
         * Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'.
         * Provide two values to evaluate for 'between'.
         * Provide a list of values for 'in'.
         */
        var operator: OperatorType?
        /**
         * List of values. Compare Name using Operator to Values.
         * If filter Name is NumberOfNodes, then values can range from 0 to 200.
         * If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100.
         * For example, filter NumberOfNodes (name) GT (operator) 3 (values).
         */
        var values: List<String>?

        fun build(): NodeConfigurationOptionsFilter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: NodeConfigurationOptionsFilterName? = null
        override var operator: OperatorType? = null
        override var values: List<String>? = null

        constructor(x: NodeConfigurationOptionsFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.values = x.values
        }

        override fun build(): NodeConfigurationOptionsFilter = NodeConfigurationOptionsFilter(this)
        override fun name(name: NodeConfigurationOptionsFilterName): FluentBuilder = apply { this.name = name }
        override fun operator(operator: OperatorType): FluentBuilder = apply { this.operator = operator }
        override fun values(values: List<String>): FluentBuilder = apply { this.values = values }
    }
}
