// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class ModifySnapshotCopyRetentionPeriodRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the cluster for which you want to change the retention
     * period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.
     * Constraints: Must be the valid name of an existing cluster that has cross-region
     * snapshot copy enabled.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual
     * snapshots instead of automated snapshots.
     */
    val manual: Boolean = builder.manual
    /**
     * The number of days to retain automated snapshots in the destination Amazon Web Services Region
     * after they are copied from the source Amazon Web Services Region.
     * By default, this only changes the retention period of copied automated snapshots.
     * If you decrease the retention period for automated snapshots that are copied to a
     * destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were
     * copied to the destination Amazon Web Services Region and that fall outside of the new retention
     * period.
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     * If you specify the manual option, only newly copied manual snapshots will
     * have the new retention period.
     * If you specify the value of -1 newly copied manual snapshots are retained
     * indefinitely.
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653
     * for manual snapshots.
     */
    val retentionPeriod: Int = builder.retentionPeriod

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifySnapshotCopyRetentionPeriodRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifySnapshotCopyRetentionPeriodRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("manual=$manual,")
        append("retentionPeriod=$retentionPeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (manual.hashCode())
        result = 31 * result + (retentionPeriod)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifySnapshotCopyRetentionPeriodRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (manual != other.manual) return false
        if (retentionPeriod != other.retentionPeriod) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifySnapshotCopyRetentionPeriodRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifySnapshotCopyRetentionPeriodRequest
        /**
         * The unique identifier of the cluster for which you want to change the retention
         * period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.
         * Constraints: Must be the valid name of an existing cluster that has cross-region
         * snapshot copy enabled.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * Indicates whether to apply the snapshot retention period to newly copied manual
         * snapshots instead of automated snapshots.
         */
        fun manual(manual: Boolean): FluentBuilder
        /**
         * The number of days to retain automated snapshots in the destination Amazon Web Services Region
         * after they are copied from the source Amazon Web Services Region.
         * By default, this only changes the retention period of copied automated snapshots.
         * If you decrease the retention period for automated snapshots that are copied to a
         * destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were
         * copied to the destination Amazon Web Services Region and that fall outside of the new retention
         * period.
         * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         * If you specify the manual option, only newly copied manual snapshots will
         * have the new retention period.
         * If you specify the value of -1 newly copied manual snapshots are retained
         * indefinitely.
         * Constraints: The number of days must be either -1 or an integer between 1 and 3,653
         * for manual snapshots.
         */
        fun retentionPeriod(retentionPeriod: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the cluster for which you want to change the retention
         * period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.
         * Constraints: Must be the valid name of an existing cluster that has cross-region
         * snapshot copy enabled.
         */
        var clusterIdentifier: String?
        /**
         * Indicates whether to apply the snapshot retention period to newly copied manual
         * snapshots instead of automated snapshots.
         */
        var manual: Boolean
        /**
         * The number of days to retain automated snapshots in the destination Amazon Web Services Region
         * after they are copied from the source Amazon Web Services Region.
         * By default, this only changes the retention period of copied automated snapshots.
         * If you decrease the retention period for automated snapshots that are copied to a
         * destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were
         * copied to the destination Amazon Web Services Region and that fall outside of the new retention
         * period.
         * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         * If you specify the manual option, only newly copied manual snapshots will
         * have the new retention period.
         * If you specify the value of -1 newly copied manual snapshots are retained
         * indefinitely.
         * Constraints: The number of days must be either -1 or an integer between 1 and 3,653
         * for manual snapshots.
         */
        var retentionPeriod: Int

        fun build(): ModifySnapshotCopyRetentionPeriodRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var manual: Boolean = false
        override var retentionPeriod: Int = 0

        constructor(x: ModifySnapshotCopyRetentionPeriodRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.manual = x.manual
            this.retentionPeriod = x.retentionPeriod
        }

        override fun build(): ModifySnapshotCopyRetentionPeriodRequest = ModifySnapshotCopyRetentionPeriodRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun manual(manual: Boolean): FluentBuilder = apply { this.manual = manual }
        override fun retentionPeriod(retentionPeriod: Int): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
    }
}
