// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule.
 * For information about which API operations can be scheduled, see  ScheduledActionType.
 */
class ModifyScheduledActionResponse private constructor(builder: BuilderImpl) {
    /**
     * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The IAM role to assume to run the scheduled action.
     * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action.
     * This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
     * For more information about the IAM role to use with the Amazon Redshift scheduler, see
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift
     * in the Amazon Redshift Cluster Management Guide.
     */
    val iamRole: String? = builder.iamRole
    /**
     * List of times when the scheduled action will run.
     */
    val nextInvocations: List<Instant>? = builder.nextInvocations
    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
     * Schedule invocations must be separated by at least one hour.
     * Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
     * Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week Year)".
     * For example, "cron(0 10 ? * MON *)". For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions
     * in the Amazon CloudWatch Events User Guide.
     */
    val schedule: String? = builder.schedule
    /**
     * The description of the scheduled action.
     */
    val scheduledActionDescription: String? = builder.scheduledActionDescription
    /**
     * The name of the scheduled action.
     */
    val scheduledActionName: String? = builder.scheduledActionName
    /**
     * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The state of the scheduled action. For example, DISABLED.
     */
    val state: ScheduledActionState? = builder.state
    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     * "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
     */
    val targetAction: ScheduledActionType? = builder.targetAction

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyScheduledActionResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyScheduledActionResponse(")
        append("endTime=$endTime,")
        append("iamRole=$iamRole,")
        append("nextInvocations=$nextInvocations,")
        append("schedule=$schedule,")
        append("scheduledActionDescription=$scheduledActionDescription,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("targetAction=$targetAction)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (nextInvocations?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (targetAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyScheduledActionResponse

        if (endTime != other.endTime) return false
        if (iamRole != other.iamRole) return false
        if (nextInvocations != other.nextInvocations) return false
        if (schedule != other.schedule) return false
        if (scheduledActionDescription != other.scheduledActionDescription) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (targetAction != other.targetAction) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyScheduledActionResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyScheduledActionResponse
        /**
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The IAM role to assume to run the scheduled action.
         * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action.
         * This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
         * For more information about the IAM role to use with the Amazon Redshift scheduler, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         */
        fun iamRole(iamRole: String): FluentBuilder
        /**
         * List of times when the scheduled action will run.
         */
        fun nextInvocations(nextInvocations: List<Instant>): FluentBuilder
        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
         * Schedule invocations must be separated by at least one hour.
         * Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
         * Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week Year)".
         * For example, "cron(0 10 ? * MON *)". For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions
         * in the Amazon CloudWatch Events User Guide.
         */
        fun schedule(schedule: String): FluentBuilder
        /**
         * The description of the scheduled action.
         */
        fun scheduledActionDescription(scheduledActionDescription: String): FluentBuilder
        /**
         * The name of the scheduled action.
         */
        fun scheduledActionName(scheduledActionName: String): FluentBuilder
        /**
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The state of the scheduled action. For example, DISABLED.
         */
        fun state(state: ScheduledActionState): FluentBuilder
        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         * "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
         */
        fun targetAction(targetAction: ScheduledActionType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.
         */
        var endTime: Instant?
        /**
         * The IAM role to assume to run the scheduled action.
         * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action.
         * This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
         * For more information about the IAM role to use with the Amazon Redshift scheduler, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         */
        var iamRole: String?
        /**
         * List of times when the scheduled action will run.
         */
        var nextInvocations: List<Instant>?
        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
         * Schedule invocations must be separated by at least one hour.
         * Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
         * Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week Year)".
         * For example, "cron(0 10 ? * MON *)". For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions
         * in the Amazon CloudWatch Events User Guide.
         */
        var schedule: String?
        /**
         * The description of the scheduled action.
         */
        var scheduledActionDescription: String?
        /**
         * The name of the scheduled action.
         */
        var scheduledActionName: String?
        /**
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         */
        var startTime: Instant?
        /**
         * The state of the scheduled action. For example, DISABLED.
         */
        var state: ScheduledActionState?
        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         * "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
         */
        var targetAction: ScheduledActionType?

        fun build(): ModifyScheduledActionResponse
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.ScheduledActionType] inside the given [block]
         */
        fun targetAction(block: ScheduledActionType.DslBuilder.() -> kotlin.Unit) {
            this.targetAction = ScheduledActionType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var iamRole: String? = null
        override var nextInvocations: List<Instant>? = null
        override var schedule: String? = null
        override var scheduledActionDescription: String? = null
        override var scheduledActionName: String? = null
        override var startTime: Instant? = null
        override var state: ScheduledActionState? = null
        override var targetAction: ScheduledActionType? = null

        constructor(x: ModifyScheduledActionResponse) : this() {
            this.endTime = x.endTime
            this.iamRole = x.iamRole
            this.nextInvocations = x.nextInvocations
            this.schedule = x.schedule
            this.scheduledActionDescription = x.scheduledActionDescription
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.state = x.state
            this.targetAction = x.targetAction
        }

        override fun build(): ModifyScheduledActionResponse = ModifyScheduledActionResponse(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun iamRole(iamRole: String): FluentBuilder = apply { this.iamRole = iamRole }
        override fun nextInvocations(nextInvocations: List<Instant>): FluentBuilder = apply { this.nextInvocations = nextInvocations }
        override fun schedule(schedule: String): FluentBuilder = apply { this.schedule = schedule }
        override fun scheduledActionDescription(scheduledActionDescription: String): FluentBuilder = apply { this.scheduledActionDescription = scheduledActionDescription }
        override fun scheduledActionName(scheduledActionName: String): FluentBuilder = apply { this.scheduledActionName = scheduledActionName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: ScheduledActionState): FluentBuilder = apply { this.state = state }
        override fun targetAction(targetAction: ScheduledActionType): FluentBuilder = apply { this.targetAction = targetAction }
    }
}
