// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class ModifyClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * If true, major version upgrades will be applied automatically to the
     * cluster during the maintenance window.
     * Default: false
     */
    val allowVersionUpgrade: Boolean? = builder.allowVersionUpgrade
    /**
     * The number of days that automated snapshots are retained. If the value is 0,
     * automated snapshots are disabled. Even if automated snapshots are disabled, you can
     * still create manual snapshots when you want with CreateClusterSnapshot.
     * If you decrease the automated snapshot retention period from its current value,
     * existing automated snapshots that fall outside of the new retention period will be
     * immediately deleted.
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     * Default: Uses existing setting.
     * Constraints: Must be a value from 0 to 35.
     */
    val automatedSnapshotRetentionPeriod: Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
     */
    val availabilityZoneRelocation: Boolean? = builder.availabilityZoneRelocation
    /**
     * The unique identifier of the cluster to be modified.
     * Example: examplecluster
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The name of the cluster parameter group to apply to this cluster. This change is
     * applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
     * Default: Uses existing setting.
     * Constraints: The cluster parameter group must be in the same parameter group family
     * that matches the cluster version.
     */
    val clusterParameterGroupName: String? = builder.clusterParameterGroupName
    /**
     * A list of cluster security groups to be authorized on this cluster. This change is
     * asynchronously applied as soon as possible.
     * Security groups currently associated with the cluster, and not in the list of
     * groups to apply, will be revoked from the cluster.
     * Constraints:
     * Must be 1 to 255 alphanumeric characters or hyphens
     * First character must be a letter
     * Cannot end with a hyphen or contain two consecutive hyphens
     */
    val clusterSecurityGroups: List<String>? = builder.clusterSecurityGroups
    /**
     * The new cluster type.
     * When you submit your cluster resize request, your existing cluster goes into a
     * read-only mode. After Amazon Redshift provisions a new cluster based on your resize
     * requirements, there will be outage for a period while the old cluster is deleted and
     * your connection is switched to the new cluster. You can use DescribeResize to track the progress of the resize request.
     * Valid Values:  multi-node | single-node
     */
    val clusterType: String? = builder.clusterType
    /**
     * The new version number of the Amazon Redshift engine to upgrade to.
     * For major version upgrades, if a non-default cluster parameter group is currently
     * in use, a new cluster parameter group in the cluster parameter group family for the new
     * version must be specified. The new cluster parameter group can be the default for that
     * cluster parameter group family.
     * For more information about parameters and parameter groups, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
     * in the Amazon Redshift Cluster Management Guide.
     * Example: 1.0
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     * The Elastic IP (EIP) address for the cluster.
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
     * through an Internet gateway. For more information about provisioning clusters in
     * EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
     * Platforms to Launch Your Cluster in the Amazon Redshift Cluster Management Guide.
     */
    val elasticIp: String? = builder.elasticIp
    /**
     * Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
     * provide a value for the KmsKeyId parameter, we encrypt the cluster
     * with the provided KmsKeyId. If you don't provide a KmsKeyId,
     * we encrypt with the default key.
     * If the value is not encrypted (false), then the cluster is decrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing
     * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
     * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
     * the Amazon Redshift Cluster Management Guide.
     * If this option is true, enhanced VPC routing is enabled.
     * Default: false
     */
    val enhancedVpcRouting: Boolean? = builder.enhancedVpcRouting
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
     * retrieve the data encryption keys stored in an HSM.
     */
    val hsmClientCertificateIdentifier: String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the
     * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    val hsmConfigurationIdentifier: String? = builder.hsmConfigurationIdentifier
    /**
     * The Key Management Service (KMS) key ID of the encryption key that you want to use
     * to encrypt data in the cluster.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name for the maintenance track that you want to assign for the cluster. This name
     * change is asynchronous. The new track name stays in the
     * PendingModifiedValues for the cluster until the next maintenance
     * window. When the maintenance track changes, the cluster is switched to the latest
     * cluster release available for the maintenance track. At this point, the maintenance
     * track name is applied.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * The default for number of days that a newly created manual snapshot is retained. If
     * the value is -1, the manual snapshot is retained indefinitely. This value doesn't
     * retroactively change the retention periods of existing manual snapshots.
     * The value must be either -1 or an integer between 1 and 3,653.
     * The default value is -1.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The new password for the cluster admin user. This change is asynchronously applied
     * as soon as possible. Between the time of the request and the completion of the request,
     * the MasterUserPassword element exists in the
     * PendingModifiedValues element of the operation response.
     * Operations never return the password, so this operation provides a way to
     * regain access to the admin user account for a cluster if the password is
     * lost.
     * Default: Uses existing setting.
     * Constraints:
     * Must be between 8 and 64 characters in length.
     * Must contain at least one uppercase letter.
     * Must contain at least one lowercase letter.
     * Must contain one number.
     * Can be any printable ASCII character (ASCII code 33 to 126) except '
     * (single quote), " (double quote), \, /, @, or space.
     */
    val masterUserPassword: String? = builder.masterUserPassword
    /**
     * The new identifier for the cluster.
     * Constraints:
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * Alphabetic characters must be lowercase.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Must be unique for all clusters within an Amazon Web Services account.
     * Example: examplecluster
     */
    val newClusterIdentifier: String? = builder.newClusterIdentifier
    /**
     * The new node type of the cluster. If you specify a new node type, you must also
     * specify the number of nodes parameter.
     * For more information about resizing clusters, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
     * in the Amazon Redshift Cluster Management Guide.
     * Valid Values: ds2.xlarge | ds2.8xlarge |
     * dc1.large | dc1.8xlarge |
     * dc2.large | dc2.8xlarge |
     * ra3.xlplus |  ra3.4xlarge | ra3.16xlarge
     */
    val nodeType: String? = builder.nodeType
    /**
     * The new number of nodes of the cluster. If you specify a new number of nodes, you
     * must also specify the node type parameter.
     * For more information about resizing clusters, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
     * in the Amazon Redshift Cluster Management Guide.
     * Valid Values: Integer greater than 0.
     */
    val numberOfNodes: Int? = builder.numberOfNodes
    /**
     * The option to change the port of an Amazon Redshift cluster.
     */
    val port: Int? = builder.port
    /**
     * The weekly time range (in UTC) during which system maintenance can occur, if
     * necessary. If system maintenance is necessary during the window, it may result in an
     * outage.
     * This maintenance window change is made immediately. If the new maintenance window
     * indicates the current time, there must be at least 120 minutes between the current time
     * and end of the window in order to ensure that pending changes are applied.
     * Default: Uses existing setting.
     * Format: ddd:hh24:mi-ddd:hh24:mi, for example
     * wed:07:30-wed:08:00.
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * Constraints: Must be at least 30 minutes.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * If true, the cluster can be accessed from a public network. Only
     * clusters in VPCs can be set to be publicly available.
     */
    val publiclyAccessible: Boolean? = builder.publiclyAccessible
    /**
     * A list of virtual private cloud (VPC) security groups to be associated with the
     * cluster. This change is asynchronously applied as soon as possible.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyClusterRequest(")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocation=$availabilityZoneRelocation,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterParameterGroupName=$clusterParameterGroupName,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterType=$clusterType,")
        append("clusterVersion=$clusterVersion,")
        append("elasticIp=$elasticIp,")
        append("encrypted=$encrypted,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUserPassword=$masterUserPassword,")
        append("newClusterIdentifier=$newClusterIdentifier,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("port=$port,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (automatedSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocation?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (elasticIp?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (hsmClientCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (newClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyClusterRequest

        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocation != other.availabilityZoneRelocation) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterParameterGroupName != other.clusterParameterGroupName) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterType != other.clusterType) return false
        if (clusterVersion != other.clusterVersion) return false
        if (elasticIp != other.elasticIp) return false
        if (encrypted != other.encrypted) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (newClusterIdentifier != other.newClusterIdentifier) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (port != other.port) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyClusterRequest
        /**
         * If true, major version upgrades will be applied automatically to the
         * cluster during the maintenance window.
         * Default: false
         */
        fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder
        /**
         * The number of days that automated snapshots are retained. If the value is 0,
         * automated snapshots are disabled. Even if automated snapshots are disabled, you can
         * still create manual snapshots when you want with CreateClusterSnapshot.
         * If you decrease the automated snapshot retention period from its current value,
         * existing automated snapshots that fall outside of the new retention period will be
         * immediately deleted.
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * Default: Uses existing setting.
         * Constraints: Must be a value from 0 to 35.
         */
        fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
         */
        fun availabilityZoneRelocation(availabilityZoneRelocation: Boolean): FluentBuilder
        /**
         * The unique identifier of the cluster to be modified.
         * Example: examplecluster
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The name of the cluster parameter group to apply to this cluster. This change is
         * applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
         * Default: Uses existing setting.
         * Constraints: The cluster parameter group must be in the same parameter group family
         * that matches the cluster version.
         */
        fun clusterParameterGroupName(clusterParameterGroupName: String): FluentBuilder
        /**
         * A list of cluster security groups to be authorized on this cluster. This change is
         * asynchronously applied as soon as possible.
         * Security groups currently associated with the cluster, and not in the list of
         * groups to apply, will be revoked from the cluster.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters or hyphens
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         */
        fun clusterSecurityGroups(clusterSecurityGroups: List<String>): FluentBuilder
        /**
         * The new cluster type.
         * When you submit your cluster resize request, your existing cluster goes into a
         * read-only mode. After Amazon Redshift provisions a new cluster based on your resize
         * requirements, there will be outage for a period while the old cluster is deleted and
         * your connection is switched to the new cluster. You can use DescribeResize to track the progress of the resize request.
         * Valid Values:  multi-node | single-node
         */
        fun clusterType(clusterType: String): FluentBuilder
        /**
         * The new version number of the Amazon Redshift engine to upgrade to.
         * For major version upgrades, if a non-default cluster parameter group is currently
         * in use, a new cluster parameter group in the cluster parameter group family for the new
         * version must be specified. The new cluster parameter group can be the default for that
         * cluster parameter group family.
         * For more information about parameters and parameter groups, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
         * in the Amazon Redshift Cluster Management Guide.
         * Example: 1.0
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         * The Elastic IP (EIP) address for the cluster.
         * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
         * through an Internet gateway. For more information about provisioning clusters in
         * EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
         * Platforms to Launch Your Cluster in the Amazon Redshift Cluster Management Guide.
         */
        fun elasticIp(elasticIp: String): FluentBuilder
        /**
         * Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
         * provide a value for the KmsKeyId parameter, we encrypt the cluster
         * with the provided KmsKeyId. If you don't provide a KmsKeyId,
         * we encrypt with the default key.
         * If the value is not encrypted (false), then the cluster is decrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder
        /**
         * The Key Management Service (KMS) key ID of the encryption key that you want to use
         * to encrypt data in the cluster.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name for the maintenance track that you want to assign for the cluster. This name
         * change is asynchronous. The new track name stays in the
         * PendingModifiedValues for the cluster until the next maintenance
         * window. When the maintenance track changes, the cluster is switched to the latest
         * cluster release available for the maintenance track. At this point, the maintenance
         * track name is applied.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * The default for number of days that a newly created manual snapshot is retained. If
         * the value is -1, the manual snapshot is retained indefinitely. This value doesn't
         * retroactively change the retention periods of existing manual snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The new password for the cluster admin user. This change is asynchronously applied
         * as soon as possible. Between the time of the request and the completion of the request,
         * the MasterUserPassword element exists in the
         * PendingModifiedValues element of the operation response.
         * Operations never return the password, so this operation provides a way to
         * regain access to the admin user account for a cluster if the password is
         * lost.
         * Default: Uses existing setting.
         * Constraints:
         * Must be between 8 and 64 characters in length.
         * Must contain at least one uppercase letter.
         * Must contain at least one lowercase letter.
         * Must contain one number.
         * Can be any printable ASCII character (ASCII code 33 to 126) except '
         * (single quote), " (double quote), \, /, @, or space.
         */
        fun masterUserPassword(masterUserPassword: String): FluentBuilder
        /**
         * The new identifier for the cluster.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         * Example: examplecluster
         */
        fun newClusterIdentifier(newClusterIdentifier: String): FluentBuilder
        /**
         * The new node type of the cluster. If you specify a new node type, you must also
         * specify the number of nodes parameter.
         * For more information about resizing clusters, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         * Valid Values: ds2.xlarge | ds2.8xlarge |
         * dc1.large | dc1.8xlarge |
         * dc2.large | dc2.8xlarge |
         * ra3.xlplus |  ra3.4xlarge | ra3.16xlarge
         */
        fun nodeType(nodeType: String): FluentBuilder
        /**
         * The new number of nodes of the cluster. If you specify a new number of nodes, you
         * must also specify the node type parameter.
         * For more information about resizing clusters, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         * Valid Values: Integer greater than 0.
         */
        fun numberOfNodes(numberOfNodes: Int): FluentBuilder
        /**
         * The option to change the port of an Amazon Redshift cluster.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, if
         * necessary. If system maintenance is necessary during the window, it may result in an
         * outage.
         * This maintenance window change is made immediately. If the new maintenance window
         * indicates the current time, there must be at least 120 minutes between the current time
         * and end of the window in order to ensure that pending changes are applied.
         * Default: Uses existing setting.
         * Format: ddd:hh24:mi-ddd:hh24:mi, for example
         * wed:07:30-wed:08:00.
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * Constraints: Must be at least 30 minutes.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * If true, the cluster can be accessed from a public network. Only
         * clusters in VPCs can be set to be publicly available.
         */
        fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder
        /**
         * A list of virtual private cloud (VPC) security groups to be associated with the
         * cluster. This change is asynchronously applied as soon as possible.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If true, major version upgrades will be applied automatically to the
         * cluster during the maintenance window.
         * Default: false
         */
        var allowVersionUpgrade: Boolean?
        /**
         * The number of days that automated snapshots are retained. If the value is 0,
         * automated snapshots are disabled. Even if automated snapshots are disabled, you can
         * still create manual snapshots when you want with CreateClusterSnapshot.
         * If you decrease the automated snapshot retention period from its current value,
         * existing automated snapshots that fall outside of the new retention period will be
         * immediately deleted.
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * Default: Uses existing setting.
         * Constraints: Must be a value from 0 to 35.
         */
        var automatedSnapshotRetentionPeriod: Int?
        /**
         * The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
         */
        var availabilityZone: String?
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
         */
        var availabilityZoneRelocation: Boolean?
        /**
         * The unique identifier of the cluster to be modified.
         * Example: examplecluster
         */
        var clusterIdentifier: String?
        /**
         * The name of the cluster parameter group to apply to this cluster. This change is
         * applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
         * Default: Uses existing setting.
         * Constraints: The cluster parameter group must be in the same parameter group family
         * that matches the cluster version.
         */
        var clusterParameterGroupName: String?
        /**
         * A list of cluster security groups to be authorized on this cluster. This change is
         * asynchronously applied as soon as possible.
         * Security groups currently associated with the cluster, and not in the list of
         * groups to apply, will be revoked from the cluster.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters or hyphens
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         */
        var clusterSecurityGroups: List<String>?
        /**
         * The new cluster type.
         * When you submit your cluster resize request, your existing cluster goes into a
         * read-only mode. After Amazon Redshift provisions a new cluster based on your resize
         * requirements, there will be outage for a period while the old cluster is deleted and
         * your connection is switched to the new cluster. You can use DescribeResize to track the progress of the resize request.
         * Valid Values:  multi-node | single-node
         */
        var clusterType: String?
        /**
         * The new version number of the Amazon Redshift engine to upgrade to.
         * For major version upgrades, if a non-default cluster parameter group is currently
         * in use, a new cluster parameter group in the cluster parameter group family for the new
         * version must be specified. The new cluster parameter group can be the default for that
         * cluster parameter group family.
         * For more information about parameters and parameter groups, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups
         * in the Amazon Redshift Cluster Management Guide.
         * Example: 1.0
         */
        var clusterVersion: String?
        /**
         * The Elastic IP (EIP) address for the cluster.
         * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
         * through an Internet gateway. For more information about provisioning clusters in
         * EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
         * Platforms to Launch Your Cluster in the Amazon Redshift Cluster Management Guide.
         */
        var elasticIp: String?
        /**
         * Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
         * provide a value for the KmsKeyId parameter, we encrypt the cluster
         * with the provided KmsKeyId. If you don't provide a KmsKeyId,
         * we encrypt with the default key.
         * If the value is not encrypted (false), then the cluster is decrypted.
         */
        var encrypted: Boolean?
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing
         * enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
         * VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing in
         * the Amazon Redshift Cluster Management Guide.
         * If this option is true, enhanced VPC routing is enabled.
         * Default: false
         */
        var enhancedVpcRouting: Boolean?
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        var hsmClientCertificateIdentifier: String?
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        var hsmConfigurationIdentifier: String?
        /**
         * The Key Management Service (KMS) key ID of the encryption key that you want to use
         * to encrypt data in the cluster.
         */
        var kmsKeyId: String?
        /**
         * The name for the maintenance track that you want to assign for the cluster. This name
         * change is asynchronous. The new track name stays in the
         * PendingModifiedValues for the cluster until the next maintenance
         * window. When the maintenance track changes, the cluster is switched to the latest
         * cluster release available for the maintenance track. At this point, the maintenance
         * track name is applied.
         */
        var maintenanceTrackName: String?
        /**
         * The default for number of days that a newly created manual snapshot is retained. If
         * the value is -1, the manual snapshot is retained indefinitely. This value doesn't
         * retroactively change the retention periods of existing manual snapshots.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * The new password for the cluster admin user. This change is asynchronously applied
         * as soon as possible. Between the time of the request and the completion of the request,
         * the MasterUserPassword element exists in the
         * PendingModifiedValues element of the operation response.
         * Operations never return the password, so this operation provides a way to
         * regain access to the admin user account for a cluster if the password is
         * lost.
         * Default: Uses existing setting.
         * Constraints:
         * Must be between 8 and 64 characters in length.
         * Must contain at least one uppercase letter.
         * Must contain at least one lowercase letter.
         * Must contain one number.
         * Can be any printable ASCII character (ASCII code 33 to 126) except '
         * (single quote), " (double quote), \, /, @, or space.
         */
        var masterUserPassword: String?
        /**
         * The new identifier for the cluster.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         * Example: examplecluster
         */
        var newClusterIdentifier: String?
        /**
         * The new node type of the cluster. If you specify a new node type, you must also
         * specify the number of nodes parameter.
         * For more information about resizing clusters, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         * Valid Values: ds2.xlarge | ds2.8xlarge |
         * dc1.large | dc1.8xlarge |
         * dc2.large | dc2.8xlarge |
         * ra3.xlplus |  ra3.4xlarge | ra3.16xlarge
         */
        var nodeType: String?
        /**
         * The new number of nodes of the cluster. If you specify a new number of nodes, you
         * must also specify the node type parameter.
         * For more information about resizing clusters, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift
         * in the Amazon Redshift Cluster Management Guide.
         * Valid Values: Integer greater than 0.
         */
        var numberOfNodes: Int?
        /**
         * The option to change the port of an Amazon Redshift cluster.
         */
        var port: Int?
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, if
         * necessary. If system maintenance is necessary during the window, it may result in an
         * outage.
         * This maintenance window change is made immediately. If the new maintenance window
         * indicates the current time, there must be at least 120 minutes between the current time
         * and end of the window in order to ensure that pending changes are applied.
         * Default: Uses existing setting.
         * Format: ddd:hh24:mi-ddd:hh24:mi, for example
         * wed:07:30-wed:08:00.
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * Constraints: Must be at least 30 minutes.
         */
        var preferredMaintenanceWindow: String?
        /**
         * If true, the cluster can be accessed from a public network. Only
         * clusters in VPCs can be set to be publicly available.
         */
        var publiclyAccessible: Boolean?
        /**
         * A list of virtual private cloud (VPC) security groups to be associated with the
         * cluster. This change is asynchronously applied as soon as possible.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): ModifyClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowVersionUpgrade: Boolean? = null
        override var automatedSnapshotRetentionPeriod: Int? = null
        override var availabilityZone: String? = null
        override var availabilityZoneRelocation: Boolean? = null
        override var clusterIdentifier: String? = null
        override var clusterParameterGroupName: String? = null
        override var clusterSecurityGroups: List<String>? = null
        override var clusterType: String? = null
        override var clusterVersion: String? = null
        override var elasticIp: String? = null
        override var encrypted: Boolean? = null
        override var enhancedVpcRouting: Boolean? = null
        override var hsmClientCertificateIdentifier: String? = null
        override var hsmConfigurationIdentifier: String? = null
        override var kmsKeyId: String? = null
        override var maintenanceTrackName: String? = null
        override var manualSnapshotRetentionPeriod: Int? = null
        override var masterUserPassword: String? = null
        override var newClusterIdentifier: String? = null
        override var nodeType: String? = null
        override var numberOfNodes: Int? = null
        override var port: Int? = null
        override var preferredMaintenanceWindow: String? = null
        override var publiclyAccessible: Boolean? = null
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: ModifyClusterRequest) : this() {
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocation = x.availabilityZoneRelocation
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterParameterGroupName = x.clusterParameterGroupName
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterType = x.clusterType
            this.clusterVersion = x.clusterVersion
            this.elasticIp = x.elasticIp
            this.encrypted = x.encrypted
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUserPassword = x.masterUserPassword
            this.newClusterIdentifier = x.newClusterIdentifier
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.port = x.port
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): ModifyClusterRequest = ModifyClusterRequest(this)
        override fun allowVersionUpgrade(allowVersionUpgrade: Boolean): FluentBuilder = apply { this.allowVersionUpgrade = allowVersionUpgrade }
        override fun automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneRelocation(availabilityZoneRelocation: Boolean): FluentBuilder = apply { this.availabilityZoneRelocation = availabilityZoneRelocation }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun clusterParameterGroupName(clusterParameterGroupName: String): FluentBuilder = apply { this.clusterParameterGroupName = clusterParameterGroupName }
        override fun clusterSecurityGroups(clusterSecurityGroups: List<String>): FluentBuilder = apply { this.clusterSecurityGroups = clusterSecurityGroups }
        override fun clusterType(clusterType: String): FluentBuilder = apply { this.clusterType = clusterType }
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun elasticIp(elasticIp: String): FluentBuilder = apply { this.elasticIp = elasticIp }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun enhancedVpcRouting(enhancedVpcRouting: Boolean): FluentBuilder = apply { this.enhancedVpcRouting = enhancedVpcRouting }
        override fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder = apply { this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier }
        override fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder = apply { this.hsmConfigurationIdentifier = hsmConfigurationIdentifier }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun masterUserPassword(masterUserPassword: String): FluentBuilder = apply { this.masterUserPassword = masterUserPassword }
        override fun newClusterIdentifier(newClusterIdentifier: String): FluentBuilder = apply { this.newClusterIdentifier = newClusterIdentifier }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
        override fun numberOfNodes(numberOfNodes: Int): FluentBuilder = apply { this.numberOfNodes = numberOfNodes }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
