// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes a modify cluster parameter group operation.
 */
class ModifyClusterParameterGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the parameter group to be modified.
     */
    val parameterGroupName: String? = builder.parameterGroupName
    /**
     * An array of parameters to be modified. A maximum of 20 parameters can be modified
     * in a single request.
     * For each parameter to be modified, you must supply at least the parameter name and
     * parameter value; other name-value pairs of the parameter are optional.
     * For the workload management (WLM) configuration, you must supply all the name-value
     * pairs in the wlm_json_configuration parameter.
     */
    val parameters: List<Parameter>? = builder.parameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyClusterParameterGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyClusterParameterGroupRequest(")
        append("parameterGroupName=$parameterGroupName,")
        append("parameters=$parameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameterGroupName?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyClusterParameterGroupRequest

        if (parameterGroupName != other.parameterGroupName) return false
        if (parameters != other.parameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyClusterParameterGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyClusterParameterGroupRequest
        /**
         * The name of the parameter group to be modified.
         */
        fun parameterGroupName(parameterGroupName: String): FluentBuilder
        /**
         * An array of parameters to be modified. A maximum of 20 parameters can be modified
         * in a single request.
         * For each parameter to be modified, you must supply at least the parameter name and
         * parameter value; other name-value pairs of the parameter are optional.
         * For the workload management (WLM) configuration, you must supply all the name-value
         * pairs in the wlm_json_configuration parameter.
         */
        fun parameters(parameters: List<Parameter>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the parameter group to be modified.
         */
        var parameterGroupName: String?
        /**
         * An array of parameters to be modified. A maximum of 20 parameters can be modified
         * in a single request.
         * For each parameter to be modified, you must supply at least the parameter name and
         * parameter value; other name-value pairs of the parameter are optional.
         * For the workload management (WLM) configuration, you must supply all the name-value
         * pairs in the wlm_json_configuration parameter.
         */
        var parameters: List<Parameter>?

        fun build(): ModifyClusterParameterGroupRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var parameterGroupName: String? = null
        override var parameters: List<Parameter>? = null

        constructor(x: ModifyClusterParameterGroupRequest) : this() {
            this.parameterGroupName = x.parameterGroupName
            this.parameters = x.parameters
        }

        override fun build(): ModifyClusterParameterGroupRequest = ModifyClusterParameterGroupRequest(this)
        override fun parameterGroupName(parameterGroupName: String): FluentBuilder = apply { this.parameterGroupName = parameterGroupName }
        override fun parameters(parameters: List<Parameter>): FluentBuilder = apply { this.parameters = parameters }
    }
}
