// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Defines a maintenance track that determines which Amazon Redshift version to apply
 * during a maintenance window. If the value for MaintenanceTrack is
 * current, the cluster is updated to the most recently certified
 * maintenance release. If the value is trailing, the cluster is updated to
 * the previously certified maintenance release.
 */
class MaintenanceTrack private constructor(builder: BuilderImpl) {
    /**
     * The version number for the cluster release.
     */
    val databaseVersion: String? = builder.databaseVersion
    /**
     * The name of the maintenance track. Possible values are current and
     * trailing.
     */
    val maintenanceTrackName: String? = builder.maintenanceTrackName
    /**
     * An array of UpdateTarget objects to update with the maintenance
     * track.
     */
    val updateTargets: List<UpdateTarget>? = builder.updateTargets

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MaintenanceTrack = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceTrack(")
        append("databaseVersion=$databaseVersion,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("updateTargets=$updateTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseVersion?.hashCode() ?: 0
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (updateTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MaintenanceTrack

        if (databaseVersion != other.databaseVersion) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (updateTargets != other.updateTargets) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MaintenanceTrack = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MaintenanceTrack
        /**
         * The version number for the cluster release.
         */
        fun databaseVersion(databaseVersion: String): FluentBuilder
        /**
         * The name of the maintenance track. Possible values are current and
         * trailing.
         */
        fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder
        /**
         * An array of UpdateTarget objects to update with the maintenance
         * track.
         */
        fun updateTargets(updateTargets: List<UpdateTarget>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The version number for the cluster release.
         */
        var databaseVersion: String?
        /**
         * The name of the maintenance track. Possible values are current and
         * trailing.
         */
        var maintenanceTrackName: String?
        /**
         * An array of UpdateTarget objects to update with the maintenance
         * track.
         */
        var updateTargets: List<UpdateTarget>?

        fun build(): MaintenanceTrack
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var databaseVersion: String? = null
        override var maintenanceTrackName: String? = null
        override var updateTargets: List<UpdateTarget>? = null

        constructor(x: MaintenanceTrack) : this() {
            this.databaseVersion = x.databaseVersion
            this.maintenanceTrackName = x.maintenanceTrackName
            this.updateTargets = x.updateTargets
        }

        override fun build(): MaintenanceTrack = MaintenanceTrack(this)
        override fun databaseVersion(databaseVersion: String): FluentBuilder = apply { this.databaseVersion = databaseVersion }
        override fun maintenanceTrackName(maintenanceTrackName: String): FluentBuilder = apply { this.maintenanceTrackName = maintenanceTrackName }
        override fun updateTargets(updateTargets: List<UpdateTarget>): FluentBuilder = apply { this.updateTargets = updateTargets }
    }
}
