// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of changes to HSM settings.
 */
class HsmStatus private constructor(builder: BuilderImpl) {
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
     * retrieve the data encryption keys stored in an HSM.
     */
    val hsmClientCertificateIdentifier: String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the
     * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    val hsmConfigurationIdentifier: String? = builder.hsmConfigurationIdentifier
    /**
     * Reports whether the Amazon Redshift cluster has finished applying any HSM settings
     * changes specified in a modify cluster command.
     * Values: active, applying
     */
    val status: String? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HsmStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HsmStatus(")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hsmClientCertificateIdentifier?.hashCode() ?: 0
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HsmStatus

        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HsmStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HsmStatus
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder
        /**
         * Reports whether the Amazon Redshift cluster has finished applying any HSM settings
         * changes specified in a modify cluster command.
         * Values: active, applying
         */
        fun status(status: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
         * retrieve the data encryption keys stored in an HSM.
         */
        var hsmClientCertificateIdentifier: String?
        /**
         * Specifies the name of the HSM configuration that contains the information the
         * Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        var hsmConfigurationIdentifier: String?
        /**
         * Reports whether the Amazon Redshift cluster has finished applying any HSM settings
         * changes specified in a modify cluster command.
         * Values: active, applying
         */
        var status: String?

        fun build(): HsmStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var hsmClientCertificateIdentifier: String? = null
        override var hsmConfigurationIdentifier: String? = null
        override var status: String? = null

        constructor(x: HsmStatus) : this() {
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.status = x.status
        }

        override fun build(): HsmStatus = HsmStatus(this)
        override fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder = apply { this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier }
        override fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder = apply { this.hsmConfigurationIdentifier = hsmConfigurationIdentifier }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
    }
}
