// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Returns information about an HSM configuration, which is an object that describes
 * to Amazon Redshift clusters the information they require to connect to an HSM where they can
 * store database encryption keys.
 */
class HsmConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A text description of the HSM configuration.
     */
    val description: String? = builder.description
    /**
     * The name of the Amazon Redshift HSM configuration.
     */
    val hsmConfigurationIdentifier: String? = builder.hsmConfigurationIdentifier
    /**
     * The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    val hsmIpAddress: String? = builder.hsmIpAddress
    /**
     * The name of the partition in the HSM where the Amazon Redshift clusters will store their
     * database encryption keys.
     */
    val hsmPartitionName: String? = builder.hsmPartitionName
    /**
     * The list of tags for the HSM configuration.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HsmConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HsmConfiguration(")
        append("description=$description,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("hsmIpAddress=$hsmIpAddress,")
        append("hsmPartitionName=$hsmPartitionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmIpAddress?.hashCode() ?: 0)
        result = 31 * result + (hsmPartitionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HsmConfiguration

        if (description != other.description) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (hsmIpAddress != other.hsmIpAddress) return false
        if (hsmPartitionName != other.hsmPartitionName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HsmConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HsmConfiguration
        /**
         * A text description of the HSM configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the Amazon Redshift HSM configuration.
         */
        fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder
        /**
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         */
        fun hsmIpAddress(hsmIpAddress: String): FluentBuilder
        /**
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their
         * database encryption keys.
         */
        fun hsmPartitionName(hsmPartitionName: String): FluentBuilder
        /**
         * The list of tags for the HSM configuration.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A text description of the HSM configuration.
         */
        var description: String?
        /**
         * The name of the Amazon Redshift HSM configuration.
         */
        var hsmConfigurationIdentifier: String?
        /**
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         */
        var hsmIpAddress: String?
        /**
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their
         * database encryption keys.
         */
        var hsmPartitionName: String?
        /**
         * The list of tags for the HSM configuration.
         */
        var tags: List<Tag>?

        fun build(): HsmConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var hsmConfigurationIdentifier: String? = null
        override var hsmIpAddress: String? = null
        override var hsmPartitionName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: HsmConfiguration) : this() {
            this.description = x.description
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.hsmIpAddress = x.hsmIpAddress
            this.hsmPartitionName = x.hsmPartitionName
            this.tags = x.tags
        }

        override fun build(): HsmConfiguration = HsmConfiguration(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder = apply { this.hsmConfigurationIdentifier = hsmConfigurationIdentifier }
        override fun hsmIpAddress(hsmIpAddress: String): FluentBuilder = apply { this.hsmIpAddress = hsmIpAddress }
        override fun hsmPartitionName(hsmPartitionName: String): FluentBuilder = apply { this.hsmPartitionName = hsmPartitionName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
