// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Returns information about an HSM client certificate. The certificate is stored in a
 * secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data
 * files.
 */
class HsmClientCertificate private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the HSM client certificate.
     */
    val hsmClientCertificateIdentifier: String? = builder.hsmClientCertificateIdentifier
    /**
     * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must
     * register the public key in the HSM.
     */
    val hsmClientCertificatePublicKey: String? = builder.hsmClientCertificatePublicKey
    /**
     * The list of tags for the HSM client certificate.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HsmClientCertificate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HsmClientCertificate(")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmClientCertificatePublicKey=$hsmClientCertificatePublicKey,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hsmClientCertificateIdentifier?.hashCode() ?: 0
        result = 31 * result + (hsmClientCertificatePublicKey?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HsmClientCertificate

        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmClientCertificatePublicKey != other.hsmClientCertificatePublicKey) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HsmClientCertificate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HsmClientCertificate
        /**
         * The identifier of the HSM client certificate.
         */
        fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder
        /**
         * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must
         * register the public key in the HSM.
         */
        fun hsmClientCertificatePublicKey(hsmClientCertificatePublicKey: String): FluentBuilder
        /**
         * The list of tags for the HSM client certificate.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the HSM client certificate.
         */
        var hsmClientCertificateIdentifier: String?
        /**
         * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must
         * register the public key in the HSM.
         */
        var hsmClientCertificatePublicKey: String?
        /**
         * The list of tags for the HSM client certificate.
         */
        var tags: List<Tag>?

        fun build(): HsmClientCertificate
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var hsmClientCertificateIdentifier: String? = null
        override var hsmClientCertificatePublicKey: String? = null
        override var tags: List<Tag>? = null

        constructor(x: HsmClientCertificate) : this() {
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmClientCertificatePublicKey = x.hsmClientCertificatePublicKey
            this.tags = x.tags
        }

        override fun build(): HsmClientCertificate = HsmClientCertificate(this)
        override fun hsmClientCertificateIdentifier(hsmClientCertificateIdentifier: String): FluentBuilder = apply { this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier }
        override fun hsmClientCertificatePublicKey(hsmClientCertificatePublicKey: String): FluentBuilder = apply { this.hsmClientCertificatePublicKey = hsmClientCertificatePublicKey }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
