// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Temporary credentials with authorization to log on to an Amazon Redshift database.
 */
class GetClusterCredentialsResponse private constructor(builder: BuilderImpl) {
    /**
     * A temporary password that authorizes the user name returned by DbUser
     * to log on to the database DbName.
     */
    val dbPassword: String? = builder.dbPassword
    /**
     * A database user name that is authorized to log on to the database
     * DbName using the password DbPassword. If the specified
     * DbUser exists in the database, the new user name has the same database privileges as the
     * the user named in DbUser. By default, the user is added to PUBLIC. If the
     * DbGroups parameter is specifed, DbUser is added to the
     * listed groups for any sessions created using these credentials.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The date and time the password in DbPassword expires.
     */
    val expiration: Instant? = builder.expiration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetClusterCredentialsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetClusterCredentialsResponse(")
        append("dbPassword=*** Sensitive Data Redacted ***,")
        append("dbUser=$dbUser,")
        append("expiration=$expiration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbPassword?.hashCode() ?: 0
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (expiration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetClusterCredentialsResponse

        if (dbPassword != other.dbPassword) return false
        if (dbUser != other.dbUser) return false
        if (expiration != other.expiration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetClusterCredentialsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetClusterCredentialsResponse
        /**
         * A temporary password that authorizes the user name returned by DbUser
         * to log on to the database DbName.
         */
        fun dbPassword(dbPassword: String): FluentBuilder
        /**
         * A database user name that is authorized to log on to the database
         * DbName using the password DbPassword. If the specified
         * DbUser exists in the database, the new user name has the same database privileges as the
         * the user named in DbUser. By default, the user is added to PUBLIC. If the
         * DbGroups parameter is specifed, DbUser is added to the
         * listed groups for any sessions created using these credentials.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The date and time the password in DbPassword expires.
         */
        fun expiration(expiration: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A temporary password that authorizes the user name returned by DbUser
         * to log on to the database DbName.
         */
        var dbPassword: String?
        /**
         * A database user name that is authorized to log on to the database
         * DbName using the password DbPassword. If the specified
         * DbUser exists in the database, the new user name has the same database privileges as the
         * the user named in DbUser. By default, the user is added to PUBLIC. If the
         * DbGroups parameter is specifed, DbUser is added to the
         * listed groups for any sessions created using these credentials.
         */
        var dbUser: String?
        /**
         * The date and time the password in DbPassword expires.
         */
        var expiration: Instant?

        fun build(): GetClusterCredentialsResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbPassword: String? = null
        override var dbUser: String? = null
        override var expiration: Instant? = null

        constructor(x: GetClusterCredentialsResponse) : this() {
            this.dbPassword = x.dbPassword
            this.dbUser = x.dbUser
            this.expiration = x.expiration
        }

        override fun build(): GetClusterCredentialsResponse = GetClusterCredentialsResponse(this)
        override fun dbPassword(dbPassword: String): FluentBuilder = apply { this.dbPassword = dbPassword }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun expiration(expiration: Instant): FluentBuilder = apply { this.expiration = expiration }
    }
}
