// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The request parameters to get cluster credentials.
 */
class GetClusterCredentialsRequest private constructor(builder: BuilderImpl) {
    /**
     * Create a database user with the name specified for the user named in
     * DbUser if one does not exist.
     */
    val autoCreate: Boolean? = builder.autoCreate
    /**
     * The unique identifier of the cluster that contains the database for which your are
     * requesting credentials. This parameter is case sensitive.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A list of the names of existing database groups that the user named in
     * DbUser will join for the current session, in addition to any group
     * memberships for an existing user. If not specified, a new user is added only to
     * PUBLIC.
     * Database group name constraints
     * Must be 1 to 64 alphanumeric characters or hyphens
     * Must contain only lowercase letters, numbers, underscore, plus sign, period
     * (dot), at symbol (@), or hyphen.
     * First character must be a letter.
     * Must not contain a colon ( : ) or slash ( / ).
     * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
     * Redshift Database Developer Guide.
     */
    val dbGroups: List<String>? = builder.dbGroups
    /**
     * The name of a database that DbUser is authorized to log on to. If
     * DbName is not specified, DbUser can log on to any existing
     * database.
     * Constraints:
     * Must be 1 to 64 alphanumeric characters or hyphens
     * Must contain only lowercase letters, numbers, underscore, plus sign, period
     * (dot), at symbol (@), or hyphen.
     * First character must be a letter.
     * Must not contain a colon ( : ) or slash ( / ).
     * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
     * Redshift Database Developer Guide.
     */
    val dbName: String? = builder.dbName
    /**
     * The name of a database user. If a user name matching DbUser exists in
     * the database, the temporary user credentials have the same permissions as the existing
     * user. If DbUser doesn't exist in the database and Autocreate
     * is True, a new user is created using the value for DbUser with
     * PUBLIC permissions. If a database user matching the value for DbUser
     * doesn't exist and Autocreate is False, then the command
     * succeeds but the connection attempt will fail because the user doesn't exist in the
     * database.
     * For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER in the Amazon
     * Redshift Database Developer Guide.
     * Constraints:
     * Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
     * PUBLIC.
     * Must contain only lowercase letters, numbers, underscore, plus sign, period
     * (dot), at symbol (@), or hyphen.
     * First character must be a letter.
     * Must not contain a colon ( : ) or slash ( / ).
     * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
     * Redshift Database Developer Guide.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The number of seconds until the returned temporary password expires.
     * Constraint: minimum 900, maximum 3600.
     * Default: 900
     */
    val durationSeconds: Int? = builder.durationSeconds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetClusterCredentialsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetClusterCredentialsRequest(")
        append("autoCreate=$autoCreate,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("dbGroups=$dbGroups,")
        append("dbName=$dbName,")
        append("dbUser=$dbUser,")
        append("durationSeconds=$durationSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoCreate?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbGroups?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (durationSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetClusterCredentialsRequest

        if (autoCreate != other.autoCreate) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (dbGroups != other.dbGroups) return false
        if (dbName != other.dbName) return false
        if (dbUser != other.dbUser) return false
        if (durationSeconds != other.durationSeconds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetClusterCredentialsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetClusterCredentialsRequest
        /**
         * Create a database user with the name specified for the user named in
         * DbUser if one does not exist.
         */
        fun autoCreate(autoCreate: Boolean): FluentBuilder
        /**
         * The unique identifier of the cluster that contains the database for which your are
         * requesting credentials. This parameter is case sensitive.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A list of the names of existing database groups that the user named in
         * DbUser will join for the current session, in addition to any group
         * memberships for an existing user. If not specified, a new user is added only to
         * PUBLIC.
         * Database group name constraints
         * Must be 1 to 64 alphanumeric characters or hyphens
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        fun dbGroups(dbGroups: List<String>): FluentBuilder
        /**
         * The name of a database that DbUser is authorized to log on to. If
         * DbName is not specified, DbUser can log on to any existing
         * database.
         * Constraints:
         * Must be 1 to 64 alphanumeric characters or hyphens
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        fun dbName(dbName: String): FluentBuilder
        /**
         * The name of a database user. If a user name matching DbUser exists in
         * the database, the temporary user credentials have the same permissions as the existing
         * user. If DbUser doesn't exist in the database and Autocreate
         * is True, a new user is created using the value for DbUser with
         * PUBLIC permissions. If a database user matching the value for DbUser
         * doesn't exist and Autocreate is False, then the command
         * succeeds but the connection attempt will fail because the user doesn't exist in the
         * database.
         * For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER in the Amazon
         * Redshift Database Developer Guide.
         * Constraints:
         * Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
         * PUBLIC.
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The number of seconds until the returned temporary password expires.
         * Constraint: minimum 900, maximum 3600.
         * Default: 900
         */
        fun durationSeconds(durationSeconds: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Create a database user with the name specified for the user named in
         * DbUser if one does not exist.
         */
        var autoCreate: Boolean?
        /**
         * The unique identifier of the cluster that contains the database for which your are
         * requesting credentials. This parameter is case sensitive.
         */
        var clusterIdentifier: String?
        /**
         * A list of the names of existing database groups that the user named in
         * DbUser will join for the current session, in addition to any group
         * memberships for an existing user. If not specified, a new user is added only to
         * PUBLIC.
         * Database group name constraints
         * Must be 1 to 64 alphanumeric characters or hyphens
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        var dbGroups: List<String>?
        /**
         * The name of a database that DbUser is authorized to log on to. If
         * DbName is not specified, DbUser can log on to any existing
         * database.
         * Constraints:
         * Must be 1 to 64 alphanumeric characters or hyphens
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        var dbName: String?
        /**
         * The name of a database user. If a user name matching DbUser exists in
         * the database, the temporary user credentials have the same permissions as the existing
         * user. If DbUser doesn't exist in the database and Autocreate
         * is True, a new user is created using the value for DbUser with
         * PUBLIC permissions. If a database user matching the value for DbUser
         * doesn't exist and Autocreate is False, then the command
         * succeeds but the connection attempt will fail because the user doesn't exist in the
         * database.
         * For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER in the Amazon
         * Redshift Database Developer Guide.
         * Constraints:
         * Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
         * PUBLIC.
         * Must contain only lowercase letters, numbers, underscore, plus sign, period
         * (dot), at symbol (@), or hyphen.
         * First character must be a letter.
         * Must not contain a colon ( : ) or slash ( / ).
         * Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words in the Amazon
         * Redshift Database Developer Guide.
         */
        var dbUser: String?
        /**
         * The number of seconds until the returned temporary password expires.
         * Constraint: minimum 900, maximum 3600.
         * Default: 900
         */
        var durationSeconds: Int?

        fun build(): GetClusterCredentialsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoCreate: Boolean? = null
        override var clusterIdentifier: String? = null
        override var dbGroups: List<String>? = null
        override var dbName: String? = null
        override var dbUser: String? = null
        override var durationSeconds: Int? = null

        constructor(x: GetClusterCredentialsRequest) : this() {
            this.autoCreate = x.autoCreate
            this.clusterIdentifier = x.clusterIdentifier
            this.dbGroups = x.dbGroups
            this.dbName = x.dbName
            this.dbUser = x.dbUser
            this.durationSeconds = x.durationSeconds
        }

        override fun build(): GetClusterCredentialsRequest = GetClusterCredentialsRequest(this)
        override fun autoCreate(autoCreate: Boolean): FluentBuilder = apply { this.autoCreate = autoCreate }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun dbGroups(dbGroups: List<String>): FluentBuilder = apply { this.dbGroups = dbGroups }
        override fun dbName(dbName: String): FluentBuilder = apply { this.dbName = dbName }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun durationSeconds(durationSeconds: Int): FluentBuilder = apply { this.durationSeconds = durationSeconds }
    }
}
