// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes event subscriptions.
 */
class EventSubscription private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon Redshift event notification subscription.
     */
    val custSubscriptionId: String? = builder.custSubscriptionId
    /**
     * The Amazon Web Services account associated with the Amazon Redshift event notification
     * subscription.
     */
    val customerAwsId: String? = builder.customerAwsId
    /**
     * A boolean value indicating whether the subscription is enabled; true
     * indicates that the subscription is enabled.
     */
    val enabled: Boolean = builder.enabled
    /**
     * The list of Amazon Redshift event categories specified in the event notification
     * subscription.
     * Values: Configuration, Management, Monitoring, Security, Pending
     */
    val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The event severity specified in the Amazon Redshift event notification
     * subscription.
     * Values: ERROR, INFO
     */
    val severity: String? = builder.severity
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
     * notification subscription.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * A list of the sources that publish events to the Amazon Redshift event notification
     * subscription.
     */
    val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The source type of the events returned by the Amazon Redshift event notification, such as
     * cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
     */
    val sourceType: String? = builder.sourceType
    /**
     * The status of the Amazon Redshift event notification subscription.
     * Constraints:
     * Can be one of the following: active | no-permission |
     * topic-not-exist
     * The status "no-permission" indicates that Amazon Redshift no longer has
     * permission to post to the Amazon SNS topic. The status "topic-not-exist"
     * indicates that the topic was deleted after the subscription was
     * created.
     */
    val status: String? = builder.status
    /**
     * The date and time the Amazon Redshift event notification subscription was
     * created.
     */
    val subscriptionCreationTime: Instant? = builder.subscriptionCreationTime
    /**
     * The list of tags for the event subscription.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventSubscription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("severity=$severity,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventSubscription

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (severity != other.severity) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventSubscription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventSubscription
        /**
         * The name of the Amazon Redshift event notification subscription.
         */
        fun custSubscriptionId(custSubscriptionId: String): FluentBuilder
        /**
         * The Amazon Web Services account associated with the Amazon Redshift event notification
         * subscription.
         */
        fun customerAwsId(customerAwsId: String): FluentBuilder
        /**
         * A boolean value indicating whether the subscription is enabled; true
         * indicates that the subscription is enabled.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * The list of Amazon Redshift event categories specified in the event notification
         * subscription.
         * Values: Configuration, Management, Monitoring, Security, Pending
         */
        fun eventCategoriesList(eventCategoriesList: List<String>): FluentBuilder
        /**
         * The event severity specified in the Amazon Redshift event notification
         * subscription.
         * Values: ERROR, INFO
         */
        fun severity(severity: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
         * notification subscription.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * A list of the sources that publish events to the Amazon Redshift event notification
         * subscription.
         */
        fun sourceIdsList(sourceIdsList: List<String>): FluentBuilder
        /**
         * The source type of the events returned by the Amazon Redshift event notification, such as
         * cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The status of the Amazon Redshift event notification subscription.
         * Constraints:
         * Can be one of the following: active | no-permission |
         * topic-not-exist
         * The status "no-permission" indicates that Amazon Redshift no longer has
         * permission to post to the Amazon SNS topic. The status "topic-not-exist"
         * indicates that the topic was deleted after the subscription was
         * created.
         */
        fun status(status: String): FluentBuilder
        /**
         * The date and time the Amazon Redshift event notification subscription was
         * created.
         */
        fun subscriptionCreationTime(subscriptionCreationTime: Instant): FluentBuilder
        /**
         * The list of tags for the event subscription.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon Redshift event notification subscription.
         */
        var custSubscriptionId: String?
        /**
         * The Amazon Web Services account associated with the Amazon Redshift event notification
         * subscription.
         */
        var customerAwsId: String?
        /**
         * A boolean value indicating whether the subscription is enabled; true
         * indicates that the subscription is enabled.
         */
        var enabled: Boolean
        /**
         * The list of Amazon Redshift event categories specified in the event notification
         * subscription.
         * Values: Configuration, Management, Monitoring, Security, Pending
         */
        var eventCategoriesList: List<String>?
        /**
         * The event severity specified in the Amazon Redshift event notification
         * subscription.
         * Values: ERROR, INFO
         */
        var severity: String?
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
         * notification subscription.
         */
        var snsTopicArn: String?
        /**
         * A list of the sources that publish events to the Amazon Redshift event notification
         * subscription.
         */
        var sourceIdsList: List<String>?
        /**
         * The source type of the events returned by the Amazon Redshift event notification, such as
         * cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
         */
        var sourceType: String?
        /**
         * The status of the Amazon Redshift event notification subscription.
         * Constraints:
         * Can be one of the following: active | no-permission |
         * topic-not-exist
         * The status "no-permission" indicates that Amazon Redshift no longer has
         * permission to post to the Amazon SNS topic. The status "topic-not-exist"
         * indicates that the topic was deleted after the subscription was
         * created.
         */
        var status: String?
        /**
         * The date and time the Amazon Redshift event notification subscription was
         * created.
         */
        var subscriptionCreationTime: Instant?
        /**
         * The list of tags for the event subscription.
         */
        var tags: List<Tag>?

        fun build(): EventSubscription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var custSubscriptionId: String? = null
        override var customerAwsId: String? = null
        override var enabled: Boolean = false
        override var eventCategoriesList: List<String>? = null
        override var severity: String? = null
        override var snsTopicArn: String? = null
        override var sourceIdsList: List<String>? = null
        override var sourceType: String? = null
        override var status: String? = null
        override var subscriptionCreationTime: Instant? = null
        override var tags: List<Tag>? = null

        constructor(x: EventSubscription) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.severity = x.severity
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
            this.tags = x.tags
        }

        override fun build(): EventSubscription = EventSubscription(this)
        override fun custSubscriptionId(custSubscriptionId: String): FluentBuilder = apply { this.custSubscriptionId = custSubscriptionId }
        override fun customerAwsId(customerAwsId: String): FluentBuilder = apply { this.customerAwsId = customerAwsId }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun eventCategoriesList(eventCategoriesList: List<String>): FluentBuilder = apply { this.eventCategoriesList = eventCategoriesList }
        override fun severity(severity: String): FluentBuilder = apply { this.severity = severity }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun sourceIdsList(sourceIdsList: List<String>): FluentBuilder = apply { this.sourceIdsList = sourceIdsList }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun subscriptionCreationTime(subscriptionCreationTime: Instant): FluentBuilder = apply { this.subscriptionCreationTime = subscriptionCreationTime }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
