// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an event.
 */
class Event private constructor(builder: BuilderImpl) {
    /**
     * The date and time of the event.
     */
    val date: Instant? = builder.date
    /**
     * A list of the event categories.
     * Values: Configuration, Management, Monitoring, Security, Pending
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The identifier of the event.
     */
    val eventId: String? = builder.eventId
    /**
     * The text of this event.
     */
    val message: String? = builder.message
    /**
     * The severity of the event.
     * Values: ERROR, INFO
     */
    val severity: String? = builder.severity
    /**
     * The identifier for the source of the event.
     */
    val sourceIdentifier: String? = builder.sourceIdentifier
    /**
     * The source type for this event.
     */
    val sourceType: SourceType? = builder.sourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Event = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("date=$date,")
        append("eventCategories=$eventCategories,")
        append("eventId=$eventId,")
        append("message=$message,")
        append("severity=$severity,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = date?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Event

        if (date != other.date) return false
        if (eventCategories != other.eventCategories) return false
        if (eventId != other.eventId) return false
        if (message != other.message) return false
        if (severity != other.severity) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Event = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Event
        /**
         * The date and time of the event.
         */
        fun date(date: Instant): FluentBuilder
        /**
         * A list of the event categories.
         * Values: Configuration, Management, Monitoring, Security, Pending
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * The identifier of the event.
         */
        fun eventId(eventId: String): FluentBuilder
        /**
         * The text of this event.
         */
        fun message(message: String): FluentBuilder
        /**
         * The severity of the event.
         * Values: ERROR, INFO
         */
        fun severity(severity: String): FluentBuilder
        /**
         * The identifier for the source of the event.
         */
        fun sourceIdentifier(sourceIdentifier: String): FluentBuilder
        /**
         * The source type for this event.
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time of the event.
         */
        var date: Instant?
        /**
         * A list of the event categories.
         * Values: Configuration, Management, Monitoring, Security, Pending
         */
        var eventCategories: List<String>?
        /**
         * The identifier of the event.
         */
        var eventId: String?
        /**
         * The text of this event.
         */
        var message: String?
        /**
         * The severity of the event.
         * Values: ERROR, INFO
         */
        var severity: String?
        /**
         * The identifier for the source of the event.
         */
        var sourceIdentifier: String?
        /**
         * The source type for this event.
         */
        var sourceType: SourceType?

        fun build(): Event
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var date: Instant? = null
        override var eventCategories: List<String>? = null
        override var eventId: String? = null
        override var message: String? = null
        override var severity: String? = null
        override var sourceIdentifier: String? = null
        override var sourceType: SourceType? = null

        constructor(x: Event) : this() {
            this.date = x.date
            this.eventCategories = x.eventCategories
            this.eventId = x.eventId
            this.message = x.message
            this.severity = x.severity
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
        }

        override fun build(): Event = Event(this)
        override fun date(date: Instant): FluentBuilder = apply { this.date = date }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun eventId(eventId: String): FluentBuilder = apply { this.eventId = eventId }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun severity(severity: String): FluentBuilder = apply { this.severity = severity }
        override fun sourceIdentifier(sourceIdentifier: String): FluentBuilder = apply { this.sourceIdentifier = sourceIdentifier }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
    }
}
