// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Redshift-managed VPC endpoint.
 */
class EndpointAccess private constructor(builder: BuilderImpl) {
    /**
     * The DNS address of the endpoint.
     */
    val address: String? = builder.address
    /**
     * The cluster identifier of the cluster associated with the endpoint.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The time (UTC) that the endpoint was created.
     */
    val endpointCreateTime: Instant? = builder.endpointCreateTime
    /**
     * The name of the endpoint.
     */
    val endpointName: String? = builder.endpointName
    /**
     * The status of the endpoint.
     */
    val endpointStatus: String? = builder.endpointStatus
    /**
     * The port number on which the cluster accepts incoming connections.
     */
    val port: Int = builder.port
    /**
     * The Amazon Web Services account ID of the owner of the cluster.
     */
    val resourceOwner: String? = builder.resourceOwner
    /**
     * The subnet group name where Amazon Redshift chooses to deploy the endpoint.
     */
    val subnetGroupName: String? = builder.subnetGroupName
    /**
     * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.
     */
    val vpcEndpoint: VpcEndpoint? = builder.vpcEndpoint
    /**
     * The security groups associated with the endpoint.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EndpointAccess = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointAccess(")
        append("address=$address,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endpointCreateTime=$endpointCreateTime,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("port=$port,")
        append("resourceOwner=$resourceOwner,")
        append("subnetGroupName=$subnetGroupName,")
        append("vpcEndpoint=$vpcEndpoint,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointCreateTime?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EndpointAccess

        if (address != other.address) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endpointCreateTime != other.endpointCreateTime) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (port != other.port) return false
        if (resourceOwner != other.resourceOwner) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (vpcEndpoint != other.vpcEndpoint) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EndpointAccess = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EndpointAccess
        /**
         * The DNS address of the endpoint.
         */
        fun address(address: String): FluentBuilder
        /**
         * The cluster identifier of the cluster associated with the endpoint.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The time (UTC) that the endpoint was created.
         */
        fun endpointCreateTime(endpointCreateTime: Instant): FluentBuilder
        /**
         * The name of the endpoint.
         */
        fun endpointName(endpointName: String): FluentBuilder
        /**
         * The status of the endpoint.
         */
        fun endpointStatus(endpointStatus: String): FluentBuilder
        /**
         * The port number on which the cluster accepts incoming connections.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the cluster.
         */
        fun resourceOwner(resourceOwner: String): FluentBuilder
        /**
         * The subnet group name where Amazon Redshift chooses to deploy the endpoint.
         */
        fun subnetGroupName(subnetGroupName: String): FluentBuilder
        /**
         * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.
         */
        fun vpcEndpoint(vpcEndpoint: VpcEndpoint): FluentBuilder
        /**
         * The security groups associated with the endpoint.
         */
        fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The DNS address of the endpoint.
         */
        var address: String?
        /**
         * The cluster identifier of the cluster associated with the endpoint.
         */
        var clusterIdentifier: String?
        /**
         * The time (UTC) that the endpoint was created.
         */
        var endpointCreateTime: Instant?
        /**
         * The name of the endpoint.
         */
        var endpointName: String?
        /**
         * The status of the endpoint.
         */
        var endpointStatus: String?
        /**
         * The port number on which the cluster accepts incoming connections.
         */
        var port: Int
        /**
         * The Amazon Web Services account ID of the owner of the cluster.
         */
        var resourceOwner: String?
        /**
         * The subnet group name where Amazon Redshift chooses to deploy the endpoint.
         */
        var subnetGroupName: String?
        /**
         * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.
         */
        var vpcEndpoint: VpcEndpoint?
        /**
         * The security groups associated with the endpoint.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>?

        fun build(): EndpointAccess
        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.VpcEndpoint] inside the given [block]
         */
        fun vpcEndpoint(block: VpcEndpoint.DslBuilder.() -> kotlin.Unit) {
            this.vpcEndpoint = VpcEndpoint.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var address: String? = null
        override var clusterIdentifier: String? = null
        override var endpointCreateTime: Instant? = null
        override var endpointName: String? = null
        override var endpointStatus: String? = null
        override var port: Int = 0
        override var resourceOwner: String? = null
        override var subnetGroupName: String? = null
        override var vpcEndpoint: VpcEndpoint? = null
        override var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        constructor(x: EndpointAccess) : this() {
            this.address = x.address
            this.clusterIdentifier = x.clusterIdentifier
            this.endpointCreateTime = x.endpointCreateTime
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.port = x.port
            this.resourceOwner = x.resourceOwner
            this.subnetGroupName = x.subnetGroupName
            this.vpcEndpoint = x.vpcEndpoint
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        override fun build(): EndpointAccess = EndpointAccess(this)
        override fun address(address: String): FluentBuilder = apply { this.address = address }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun endpointCreateTime(endpointCreateTime: Instant): FluentBuilder = apply { this.endpointCreateTime = endpointCreateTime }
        override fun endpointName(endpointName: String): FluentBuilder = apply { this.endpointName = endpointName }
        override fun endpointStatus(endpointStatus: String): FluentBuilder = apply { this.endpointStatus = endpointStatus }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun resourceOwner(resourceOwner: String): FluentBuilder = apply { this.resourceOwner = resourceOwner }
        override fun subnetGroupName(subnetGroupName: String): FluentBuilder = apply { this.subnetGroupName = subnetGroupName }
        override fun vpcEndpoint(vpcEndpoint: VpcEndpoint): FluentBuilder = apply { this.vpcEndpoint = vpcEndpoint }
        override fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder = apply { this.vpcSecurityGroups = vpcSecurityGroups }
    }
}
