// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class EnableSnapshotCopyRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the source cluster to copy snapshots from.
     * Constraints: Must be the valid name of an existing cluster that does not already
     * have cross-region snapshot copy enabled.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The destination Amazon Web Services Region that you want to copy snapshots to.
     * Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints in the Amazon Web Services General Reference.
     */
    val destinationRegion: String? = builder.destinationRegion
    /**
     * The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
     * after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
     * snapshot is retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    val manualSnapshotRetentionPeriod: Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The number of days to retain automated snapshots in the destination region after
     * they are copied from the source region.
     * Default: 7.
     * Constraints: Must be at least 1 and no more than 35.
     */
    val retentionPeriod: Int? = builder.retentionPeriod
    /**
     * The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
     * cluster are copied to the destination region.
     */
    val snapshotCopyGrantName: String? = builder.snapshotCopyGrantName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EnableSnapshotCopyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EnableSnapshotCopyRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("destinationRegion=$destinationRegion,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (destinationRegion?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnableSnapshotCopyRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (destinationRegion != other.destinationRegion) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EnableSnapshotCopyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EnableSnapshotCopyRequest
        /**
         * The unique identifier of the source cluster to copy snapshots from.
         * Constraints: Must be the valid name of an existing cluster that does not already
         * have cross-region snapshot copy enabled.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The destination Amazon Web Services Region that you want to copy snapshots to.
         * Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints in the Amazon Web Services General Reference.
         */
        fun destinationRegion(destinationRegion: String): FluentBuilder
        /**
         * The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
         * after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * The number of days to retain automated snapshots in the destination region after
         * they are copied from the source region.
         * Default: 7.
         * Constraints: Must be at least 1 and no more than 35.
         */
        fun retentionPeriod(retentionPeriod: Int): FluentBuilder
        /**
         * The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
         * cluster are copied to the destination region.
         */
        fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the source cluster to copy snapshots from.
         * Constraints: Must be the valid name of an existing cluster that does not already
         * have cross-region snapshot copy enabled.
         */
        var clusterIdentifier: String?
        /**
         * The destination Amazon Web Services Region that you want to copy snapshots to.
         * Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints in the Amazon Web Services General Reference.
         */
        var destinationRegion: String?
        /**
         * The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
         * after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        var manualSnapshotRetentionPeriod: Int?
        /**
         * The number of days to retain automated snapshots in the destination region after
         * they are copied from the source region.
         * Default: 7.
         * Constraints: Must be at least 1 and no more than 35.
         */
        var retentionPeriod: Int?
        /**
         * The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
         * cluster are copied to the destination region.
         */
        var snapshotCopyGrantName: String?

        fun build(): EnableSnapshotCopyRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var destinationRegion: String? = null
        override var manualSnapshotRetentionPeriod: Int? = null
        override var retentionPeriod: Int? = null
        override var snapshotCopyGrantName: String? = null

        constructor(x: EnableSnapshotCopyRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.destinationRegion = x.destinationRegion
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.retentionPeriod = x.retentionPeriod
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
        }

        override fun build(): EnableSnapshotCopyRequest = EnableSnapshotCopyRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun destinationRegion(destinationRegion: String): FluentBuilder = apply { this.destinationRegion = destinationRegion }
        override fun manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod }
        override fun retentionPeriod(retentionPeriod: Int): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder = apply { this.snapshotCopyGrantName = snapshotCopyGrantName }
    }
}
