// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class EnableLoggingRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of an existing S3 bucket where the log files are to be stored.
     * Constraints:
     * Must be in the same region as the cluster
     * The cluster must have read bucket and put object permissions
     */
    val bucketName: String? = builder.bucketName
    /**
     * The identifier of the cluster on which logging is to be started.
     * Example: examplecluster
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The prefix applied to the log file names.
     * Constraints:
     * Cannot exceed 512 characters
     * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
     * (\), or control characters. The hexadecimal codes for invalid characters are:
     * x00 to x20
     * x22
     * x27
     * x5c
     * x7f or larger
     */
    val s3KeyPrefix: String? = builder.s3KeyPrefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EnableLoggingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EnableLoggingRequest(")
        append("bucketName=$bucketName,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("s3KeyPrefix=$s3KeyPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnableLoggingRequest

        if (bucketName != other.bucketName) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EnableLoggingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EnableLoggingRequest
        /**
         * The name of an existing S3 bucket where the log files are to be stored.
         * Constraints:
         * Must be in the same region as the cluster
         * The cluster must have read bucket and put object permissions
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * The identifier of the cluster on which logging is to be started.
         * Example: examplecluster
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The prefix applied to the log file names.
         * Constraints:
         * Cannot exceed 512 characters
         * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
         * (\), or control characters. The hexadecimal codes for invalid characters are:
         * x00 to x20
         * x22
         * x27
         * x5c
         * x7f or larger
         */
        fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of an existing S3 bucket where the log files are to be stored.
         * Constraints:
         * Must be in the same region as the cluster
         * The cluster must have read bucket and put object permissions
         */
        var bucketName: String?
        /**
         * The identifier of the cluster on which logging is to be started.
         * Example: examplecluster
         */
        var clusterIdentifier: String?
        /**
         * The prefix applied to the log file names.
         * Constraints:
         * Cannot exceed 512 characters
         * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
         * (\), or control characters. The hexadecimal codes for invalid characters are:
         * x00 to x20
         * x22
         * x27
         * x5c
         * x7f or larger
         */
        var s3KeyPrefix: String?

        fun build(): EnableLoggingRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketName: String? = null
        override var clusterIdentifier: String? = null
        override var s3KeyPrefix: String? = null

        constructor(x: EnableLoggingRequest) : this() {
            this.bucketName = x.bucketName
            this.clusterIdentifier = x.clusterIdentifier
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        override fun build(): EnableLoggingRequest = EnableLoggingRequest(this)
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder = apply { this.s3KeyPrefix = s3KeyPrefix }
    }
}
