// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes an Amazon EC2 security group.
 */
class Ec2SecurityGroup private constructor(builder: BuilderImpl) {
    /**
     * The name of the EC2 Security Group.
     */
    val ec2SecurityGroupName: String? = builder.ec2SecurityGroupName
    /**
     * The Amazon Web Services account ID of the owner of the EC2 security group specified in the
     * EC2SecurityGroupName field.
     */
    val ec2SecurityGroupOwnerId: String? = builder.ec2SecurityGroupOwnerId
    /**
     * The status of the EC2 security group.
     */
    val status: String? = builder.status
    /**
     * The list of tags for the EC2 security group.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Ec2SecurityGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2SecurityGroup(")
        append("ec2SecurityGroupName=$ec2SecurityGroupName,")
        append("ec2SecurityGroupOwnerId=$ec2SecurityGroupOwnerId,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2SecurityGroupName?.hashCode() ?: 0
        result = 31 * result + (ec2SecurityGroupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Ec2SecurityGroup

        if (ec2SecurityGroupName != other.ec2SecurityGroupName) return false
        if (ec2SecurityGroupOwnerId != other.ec2SecurityGroupOwnerId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Ec2SecurityGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Ec2SecurityGroup
        /**
         * The name of the EC2 Security Group.
         */
        fun ec2SecurityGroupName(ec2SecurityGroupName: String): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the EC2 security group specified in the
         * EC2SecurityGroupName field.
         */
        fun ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId: String): FluentBuilder
        /**
         * The status of the EC2 security group.
         */
        fun status(status: String): FluentBuilder
        /**
         * The list of tags for the EC2 security group.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the EC2 Security Group.
         */
        var ec2SecurityGroupName: String?
        /**
         * The Amazon Web Services account ID of the owner of the EC2 security group specified in the
         * EC2SecurityGroupName field.
         */
        var ec2SecurityGroupOwnerId: String?
        /**
         * The status of the EC2 security group.
         */
        var status: String?
        /**
         * The list of tags for the EC2 security group.
         */
        var tags: List<Tag>?

        fun build(): Ec2SecurityGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ec2SecurityGroupName: String? = null
        override var ec2SecurityGroupOwnerId: String? = null
        override var status: String? = null
        override var tags: List<Tag>? = null

        constructor(x: Ec2SecurityGroup) : this() {
            this.ec2SecurityGroupName = x.ec2SecurityGroupName
            this.ec2SecurityGroupOwnerId = x.ec2SecurityGroupOwnerId
            this.status = x.status
            this.tags = x.tags
        }

        override fun build(): Ec2SecurityGroup = Ec2SecurityGroup(this)
        override fun ec2SecurityGroupName(ec2SecurityGroupName: String): FluentBuilder = apply { this.ec2SecurityGroupName = ec2SecurityGroupName }
        override fun ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId: String): FluentBuilder = apply { this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
