// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeTagsRequest private constructor(builder: BuilderImpl) {
    /**
     * A value that indicates the starting point for the next set of response records in a
     * subsequent request. If a value is returned in a response, you can retrieve the next set
     * of records by providing this returned marker value in the marker parameter
     * and retrying the command. If the marker field is empty, all response
     * records have been retrieved for the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number or response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
     * example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
     */
    val resourceName: String? = builder.resourceName
    /**
     * The type of resource with which you want to view tags. Valid resource types are:
     * Cluster
     * CIDR/IP
     * EC2 security group
     * Snapshot
     * Cluster security group
     * Subnet group
     * HSM connection
     * HSM certificate
     * Parameter group
     * Snapshot copy grant
     * For more information about Amazon Redshift resource types and constructing ARNs, go to
     * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals in
     * the Amazon Redshift Cluster Management Guide.
     */
    val resourceType: String? = builder.resourceType
    /**
     * A tag key or keys for which you want to return all matching resources that are
     * associated with the specified key or keys. For example, suppose that you have resources
     * tagged with keys called owner and environment. If you specify
     * both of these tag keys in the request, Amazon Redshift returns a response with all resources
     * that have either or both of these tag keys associated with them.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching resources that are
     * associated with the specified value or values. For example, suppose that you have
     * resources tagged with values called admin and test. If you
     * specify both of these tag values in the request, Amazon Redshift returns a response with all
     * resources that have either or both of these tag values associated with them.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeTagsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTagsRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeTagsRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeTagsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeTagsRequest
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the marker parameter
         * and retrying the command. If the marker field is empty, all response
         * records have been retrieved for the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number or response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
         * example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
         */
        fun resourceName(resourceName: String): FluentBuilder
        /**
         * The type of resource with which you want to view tags. Valid resource types are:
         * Cluster
         * CIDR/IP
         * EC2 security group
         * Snapshot
         * Cluster security group
         * Subnet group
         * HSM connection
         * HSM certificate
         * Parameter group
         * Snapshot copy grant
         * For more information about Amazon Redshift resource types and constructing ARNs, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals in
         * the Amazon Redshift Cluster Management Guide.
         */
        fun resourceType(resourceType: String): FluentBuilder
        /**
         * A tag key or keys for which you want to return all matching resources that are
         * associated with the specified key or keys. For example, suppose that you have resources
         * tagged with keys called owner and environment. If you specify
         * both of these tag keys in the request, Amazon Redshift returns a response with all resources
         * that have either or both of these tag keys associated with them.
         */
        fun tagKeys(tagKeys: List<String>): FluentBuilder
        /**
         * A tag value or values for which you want to return all matching resources that are
         * associated with the specified value or values. For example, suppose that you have
         * resources tagged with values called admin and test. If you
         * specify both of these tag values in the request, Amazon Redshift returns a response with all
         * resources that have either or both of these tag values associated with them.
         */
        fun tagValues(tagValues: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the marker parameter
         * and retrying the command. If the marker field is empty, all response
         * records have been retrieved for the request.
         */
        var marker: String?
        /**
         * The maximum number or response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        var maxRecords: Int?
        /**
         * The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
         * example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
         */
        var resourceName: String?
        /**
         * The type of resource with which you want to view tags. Valid resource types are:
         * Cluster
         * CIDR/IP
         * EC2 security group
         * Snapshot
         * Cluster security group
         * Subnet group
         * HSM connection
         * HSM certificate
         * Parameter group
         * Snapshot copy grant
         * For more information about Amazon Redshift resource types and constructing ARNs, go to
         * <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals in
         * the Amazon Redshift Cluster Management Guide.
         */
        var resourceType: String?
        /**
         * A tag key or keys for which you want to return all matching resources that are
         * associated with the specified key or keys. For example, suppose that you have resources
         * tagged with keys called owner and environment. If you specify
         * both of these tag keys in the request, Amazon Redshift returns a response with all resources
         * that have either or both of these tag keys associated with them.
         */
        var tagKeys: List<String>?
        /**
         * A tag value or values for which you want to return all matching resources that are
         * associated with the specified value or values. For example, suppose that you have
         * resources tagged with values called admin and test. If you
         * specify both of these tag values in the request, Amazon Redshift returns a response with all
         * resources that have either or both of these tag values associated with them.
         */
        var tagValues: List<String>?

        fun build(): DescribeTagsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var resourceName: String? = null
        override var resourceType: String? = null
        override var tagKeys: List<String>? = null
        override var tagValues: List<String>? = null

        constructor(x: DescribeTagsRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        override fun build(): DescribeTagsRequest = DescribeTagsRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun resourceName(resourceName: String): FluentBuilder = apply { this.resourceName = resourceName }
        override fun resourceType(resourceType: String): FluentBuilder = apply { this.resourceType = resourceType }
        override fun tagKeys(tagKeys: List<String>): FluentBuilder = apply { this.tagKeys = tagKeys }
        override fun tagValues(tagValues: List<String>): FluentBuilder = apply { this.tagValues = tagValues }
    }
}
