// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeTableRestoreStatusRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Redshift cluster that the table is being restored to.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * An optional pagination token provided by a previous
     * DescribeTableRestoreStatus request. If this parameter is specified, the
     * response includes only records beyond the marker, up to the value specified by the
     * MaxRecords parameter.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist
     * than the specified MaxRecords value, a pagination token called a marker is
     * included in the response so that the remaining results can be retrieved.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The identifier of the table restore request to return status for. If you don't
     * specify a TableRestoreRequestId value, then
     * DescribeTableRestoreStatus returns the status of all in-progress table
     * restore requests.
     */
    val tableRestoreRequestId: String? = builder.tableRestoreRequestId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeTableRestoreStatusRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTableRestoreStatusRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("tableRestoreRequestId=$tableRestoreRequestId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (tableRestoreRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeTableRestoreStatusRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (tableRestoreRequestId != other.tableRestoreRequestId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeTableRestoreStatusRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeTableRestoreStatusRequest
        /**
         * The Amazon Redshift cluster that the table is being restored to.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * An optional pagination token provided by a previous
         * DescribeTableRestoreStatus request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a marker is
         * included in the response so that the remaining results can be retrieved.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The identifier of the table restore request to return status for. If you don't
         * specify a TableRestoreRequestId value, then
         * DescribeTableRestoreStatus returns the status of all in-progress table
         * restore requests.
         */
        fun tableRestoreRequestId(tableRestoreRequestId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Redshift cluster that the table is being restored to.
         */
        var clusterIdentifier: String?
        /**
         * An optional pagination token provided by a previous
         * DescribeTableRestoreStatus request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a marker is
         * included in the response so that the remaining results can be retrieved.
         */
        var maxRecords: Int?
        /**
         * The identifier of the table restore request to return status for. If you don't
         * specify a TableRestoreRequestId value, then
         * DescribeTableRestoreStatus returns the status of all in-progress table
         * restore requests.
         */
        var tableRestoreRequestId: String?

        fun build(): DescribeTableRestoreStatusRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var tableRestoreRequestId: String? = null

        constructor(x: DescribeTableRestoreStatusRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.tableRestoreRequestId = x.tableRestoreRequestId
        }

        override fun build(): DescribeTableRestoreStatusRequest = DescribeTableRestoreStatusRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun tableRestoreRequestId(tableRestoreRequestId: String): FluentBuilder = apply { this.tableRestoreRequestId = tableRestoreRequestId }
    }
}
