// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeSnapshotSchedulesRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the cluster whose snapshot schedules you want to
     * view.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A value that indicates the starting point for the next set of response records in a
     * subsequent request. If a value is returned in a response, you can retrieve the next set
     * of records by providing this returned marker value in the marker parameter
     * and retrying the command. If the marker field is empty, all response
     * records have been retrieved for the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number or response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker
     * value.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * A unique identifier for a snapshot schedule.
     */
    val scheduleIdentifier: String? = builder.scheduleIdentifier
    /**
     * The key value for a snapshot schedule tag.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * The value corresponding to the key of the snapshot schedule tag.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSnapshotSchedulesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotSchedulesRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("scheduleIdentifier=$scheduleIdentifier,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (scheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSnapshotSchedulesRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (scheduleIdentifier != other.scheduleIdentifier) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSnapshotSchedulesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSnapshotSchedulesRequest
        /**
         * The unique identifier for the cluster whose snapshot schedules you want to
         * view.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the marker parameter
         * and retrying the command. If the marker field is empty, all response
         * records have been retrieved for the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number or response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker
         * value.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * A unique identifier for a snapshot schedule.
         */
        fun scheduleIdentifier(scheduleIdentifier: String): FluentBuilder
        /**
         * The key value for a snapshot schedule tag.
         */
        fun tagKeys(tagKeys: List<String>): FluentBuilder
        /**
         * The value corresponding to the key of the snapshot schedule tag.
         */
        fun tagValues(tagValues: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the cluster whose snapshot schedules you want to
         * view.
         */
        var clusterIdentifier: String?
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the marker parameter
         * and retrying the command. If the marker field is empty, all response
         * records have been retrieved for the request.
         */
        var marker: String?
        /**
         * The maximum number or response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker
         * value.
         */
        var maxRecords: Int?
        /**
         * A unique identifier for a snapshot schedule.
         */
        var scheduleIdentifier: String?
        /**
         * The key value for a snapshot schedule tag.
         */
        var tagKeys: List<String>?
        /**
         * The value corresponding to the key of the snapshot schedule tag.
         */
        var tagValues: List<String>?

        fun build(): DescribeSnapshotSchedulesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var scheduleIdentifier: String? = null
        override var tagKeys: List<String>? = null
        override var tagValues: List<String>? = null

        constructor(x: DescribeSnapshotSchedulesRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.scheduleIdentifier = x.scheduleIdentifier
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        override fun build(): DescribeSnapshotSchedulesRequest = DescribeSnapshotSchedulesRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun scheduleIdentifier(scheduleIdentifier: String): FluentBuilder = apply { this.scheduleIdentifier = scheduleIdentifier }
        override fun tagKeys(tagKeys: List<String>): FluentBuilder = apply { this.tagKeys = tagKeys }
        override fun tagValues(tagValues: List<String>): FluentBuilder = apply { this.tagValues = tagValues }
    }
}
