// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The result of the DescribeSnapshotCopyGrants action.
 */
class DescribeSnapshotCopyGrantsRequest private constructor(builder: BuilderImpl) {
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeSnapshotCopyGrant request exceed the
     * value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     * Constraints: You can specify either the SnapshotCopyGrantName parameter or the Marker parameter, but not both.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The name of the snapshot copy grant.
     */
    val snapshotCopyGrantName: String? = builder.snapshotCopyGrantName
    /**
     * A tag key or keys for which you want to return all matching resources that are
     * associated with the specified key or keys. For example, suppose that you have resources
     * tagged with keys called owner and environment. If you specify
     * both of these tag keys in the request, Amazon Redshift returns a response with all resources
     * that have either or both of these tag keys associated with them.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching resources that are
     * associated with the specified value or values. For example, suppose that you have
     * resources tagged with values called admin and test. If you
     * specify both of these tag values in the request, Amazon Redshift returns a response with all
     * resources that have either or both of these tag values associated with them.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSnapshotCopyGrantsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotCopyGrantsRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSnapshotCopyGrantsRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSnapshotCopyGrantsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSnapshotCopyGrantsRequest
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeSnapshotCopyGrant request exceed the
         * value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         * Constraints: You can specify either the SnapshotCopyGrantName parameter or the Marker parameter, but not both.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The name of the snapshot copy grant.
         */
        fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder
        /**
         * A tag key or keys for which you want to return all matching resources that are
         * associated with the specified key or keys. For example, suppose that you have resources
         * tagged with keys called owner and environment. If you specify
         * both of these tag keys in the request, Amazon Redshift returns a response with all resources
         * that have either or both of these tag keys associated with them.
         */
        fun tagKeys(tagKeys: List<String>): FluentBuilder
        /**
         * A tag value or values for which you want to return all matching resources that are
         * associated with the specified value or values. For example, suppose that you have
         * resources tagged with values called admin and test. If you
         * specify both of these tag values in the request, Amazon Redshift returns a response with all
         * resources that have either or both of these tag values associated with them.
         */
        fun tagValues(tagValues: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeSnapshotCopyGrant request exceed the
         * value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         * Constraints: You can specify either the SnapshotCopyGrantName parameter or the Marker parameter, but not both.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The name of the snapshot copy grant.
         */
        var snapshotCopyGrantName: String?
        /**
         * A tag key or keys for which you want to return all matching resources that are
         * associated with the specified key or keys. For example, suppose that you have resources
         * tagged with keys called owner and environment. If you specify
         * both of these tag keys in the request, Amazon Redshift returns a response with all resources
         * that have either or both of these tag keys associated with them.
         */
        var tagKeys: List<String>?
        /**
         * A tag value or values for which you want to return all matching resources that are
         * associated with the specified value or values. For example, suppose that you have
         * resources tagged with values called admin and test. If you
         * specify both of these tag values in the request, Amazon Redshift returns a response with all
         * resources that have either or both of these tag values associated with them.
         */
        var tagValues: List<String>?

        fun build(): DescribeSnapshotCopyGrantsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var snapshotCopyGrantName: String? = null
        override var tagKeys: List<String>? = null
        override var tagValues: List<String>? = null

        constructor(x: DescribeSnapshotCopyGrantsRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        override fun build(): DescribeSnapshotCopyGrantsRequest = DescribeSnapshotCopyGrantsRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder = apply { this.snapshotCopyGrantName = snapshotCopyGrantName }
        override fun tagKeys(tagKeys: List<String>): FluentBuilder = apply { this.tagKeys = tagKeys }
        override fun tagValues(tagValues: List<String>): FluentBuilder = apply { this.tagValues = tagValues }
    }
}
