// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeScheduledActionsRequest private constructor(builder: BuilderImpl) {
    /**
     * If true, retrieve only active scheduled actions.
     * If false, retrieve only disabled scheduled actions.
     */
    val active: Boolean? = builder.active
    /**
     * The end time in UTC of the scheduled action to retrieve.
     * Only active scheduled actions that have invocations before this time are retrieved.
     */
    val endTime: Instant? = builder.endTime
    /**
     * List of scheduled action filters.
     */
    val filters: List<ScheduledActionFilter>? = builder.filters
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeScheduledActions request
     * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The name of the scheduled action to retrieve.
     */
    val scheduledActionName: String? = builder.scheduledActionName
    /**
     * The start time in UTC of the scheduled actions to retrieve.
     * Only active scheduled actions that have invocations after this time are retrieved.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The type of the scheduled actions to retrieve.
     */
    val targetActionType: ScheduledActionTypeValues? = builder.targetActionType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeScheduledActionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledActionsRequest(")
        append("active=$active,")
        append("endTime=$endTime,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("targetActionType=$targetActionType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (targetActionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeScheduledActionsRequest

        if (active != other.active) return false
        if (endTime != other.endTime) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (targetActionType != other.targetActionType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeScheduledActionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeScheduledActionsRequest
        /**
         * If true, retrieve only active scheduled actions.
         * If false, retrieve only disabled scheduled actions.
         */
        fun active(active: Boolean): FluentBuilder
        /**
         * The end time in UTC of the scheduled action to retrieve.
         * Only active scheduled actions that have invocations before this time are retrieved.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * List of scheduled action filters.
         */
        fun filters(filters: List<ScheduledActionFilter>): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeScheduledActions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The name of the scheduled action to retrieve.
         */
        fun scheduledActionName(scheduledActionName: String): FluentBuilder
        /**
         * The start time in UTC of the scheduled actions to retrieve.
         * Only active scheduled actions that have invocations after this time are retrieved.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The type of the scheduled actions to retrieve.
         */
        fun targetActionType(targetActionType: ScheduledActionTypeValues): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If true, retrieve only active scheduled actions.
         * If false, retrieve only disabled scheduled actions.
         */
        var active: Boolean?
        /**
         * The end time in UTC of the scheduled action to retrieve.
         * Only active scheduled actions that have invocations before this time are retrieved.
         */
        var endTime: Instant?
        /**
         * List of scheduled action filters.
         */
        var filters: List<ScheduledActionFilter>?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeScheduledActions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The name of the scheduled action to retrieve.
         */
        var scheduledActionName: String?
        /**
         * The start time in UTC of the scheduled actions to retrieve.
         * Only active scheduled actions that have invocations after this time are retrieved.
         */
        var startTime: Instant?
        /**
         * The type of the scheduled actions to retrieve.
         */
        var targetActionType: ScheduledActionTypeValues?

        fun build(): DescribeScheduledActionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var active: Boolean? = null
        override var endTime: Instant? = null
        override var filters: List<ScheduledActionFilter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var scheduledActionName: String? = null
        override var startTime: Instant? = null
        override var targetActionType: ScheduledActionTypeValues? = null

        constructor(x: DescribeScheduledActionsRequest) : this() {
            this.active = x.active
            this.endTime = x.endTime
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.targetActionType = x.targetActionType
        }

        override fun build(): DescribeScheduledActionsRequest = DescribeScheduledActionsRequest(this)
        override fun active(active: Boolean): FluentBuilder = apply { this.active = active }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun filters(filters: List<ScheduledActionFilter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun scheduledActionName(scheduledActionName: String): FluentBuilder = apply { this.scheduledActionName = scheduledActionName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun targetActionType(targetActionType: ScheduledActionTypeValues): FluentBuilder = apply { this.targetActionType = targetActionType }
    }
}
