// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeOrderableClusterOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The version filter value. Specify this parameter to show only the available
     * offerings matching the specified version.
     * Default: All versions.
     * Constraints: Must be one of the version returned from DescribeClusterVersions.
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeOrderableClusterOptions request
     * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The node type filter value. Specify this parameter to show only the available
     * offerings matching the specified node type.
     */
    val nodeType: String? = builder.nodeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeOrderableClusterOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeOrderableClusterOptionsRequest(")
        append("clusterVersion=$clusterVersion,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("nodeType=$nodeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterVersion?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeOrderableClusterOptionsRequest

        if (clusterVersion != other.clusterVersion) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (nodeType != other.nodeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeOrderableClusterOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeOrderableClusterOptionsRequest
        /**
         * The version filter value. Specify this parameter to show only the available
         * offerings matching the specified version.
         * Default: All versions.
         * Constraints: Must be one of the version returned from DescribeClusterVersions.
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeOrderableClusterOptions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The node type filter value. Specify this parameter to show only the available
         * offerings matching the specified node type.
         */
        fun nodeType(nodeType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The version filter value. Specify this parameter to show only the available
         * offerings matching the specified version.
         * Default: All versions.
         * Constraints: Must be one of the version returned from DescribeClusterVersions.
         */
        var clusterVersion: String?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeOrderableClusterOptions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The node type filter value. Specify this parameter to show only the available
         * offerings matching the specified node type.
         */
        var nodeType: String?

        fun build(): DescribeOrderableClusterOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterVersion: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var nodeType: String? = null

        constructor(x: DescribeOrderableClusterOptionsRequest) : this() {
            this.clusterVersion = x.clusterVersion
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.nodeType = x.nodeType
        }

        override fun build(): DescribeOrderableClusterOptionsRequest = DescribeOrderableClusterOptionsRequest(this)
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun nodeType(nodeType: String): FluentBuilder = apply { this.nodeType = nodeType }
    }
}
