// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeNodeConfigurationOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The action type to evaluate for possible node configurations.
     * Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
     * Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
     * Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
     */
    val actionType: ActionType? = builder.actionType
    /**
     * The identifier of the cluster to evaluate for possible node configurations.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A set of name, operator, and value items to filter the results.
     */
    val filters: List<NodeConfigurationOptionsFilter>? = builder.filters
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeNodeConfigurationOptions request
     * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 500
     * Constraints: minimum 100, maximum 500.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The Amazon Web Services account used to create or copy the snapshot.
     * Required if you are restoring a snapshot you do not own,
     * optional if you own the snapshot.
     */
    val ownerAccount: String? = builder.ownerAccount
    /**
     * The identifier of the snapshot to evaluate for possible node configurations.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeNodeConfigurationOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNodeConfigurationOptionsRequest(")
        append("actionType=$actionType,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotIdentifier=$snapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeNodeConfigurationOptionsRequest

        if (actionType != other.actionType) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeNodeConfigurationOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeNodeConfigurationOptionsRequest
        /**
         * The action type to evaluate for possible node configurations.
         * Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
         * Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
         * Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
         */
        fun actionType(actionType: ActionType): FluentBuilder
        /**
         * The identifier of the cluster to evaluate for possible node configurations.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A set of name, operator, and value items to filter the results.
         */
        fun filters(filters: List<NodeConfigurationOptionsFilter>): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeNodeConfigurationOptions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 500
         * Constraints: minimum 100, maximum 500.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The Amazon Web Services account used to create or copy the snapshot.
         * Required if you are restoring a snapshot you do not own,
         * optional if you own the snapshot.
         */
        fun ownerAccount(ownerAccount: String): FluentBuilder
        /**
         * The identifier of the snapshot to evaluate for possible node configurations.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action type to evaluate for possible node configurations.
         * Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
         * Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
         * Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
         */
        var actionType: ActionType?
        /**
         * The identifier of the cluster to evaluate for possible node configurations.
         */
        var clusterIdentifier: String?
        /**
         * A set of name, operator, and value items to filter the results.
         */
        var filters: List<NodeConfigurationOptionsFilter>?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeNodeConfigurationOptions request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 500
         * Constraints: minimum 100, maximum 500.
         */
        var maxRecords: Int?
        /**
         * The Amazon Web Services account used to create or copy the snapshot.
         * Required if you are restoring a snapshot you do not own,
         * optional if you own the snapshot.
         */
        var ownerAccount: String?
        /**
         * The identifier of the snapshot to evaluate for possible node configurations.
         */
        var snapshotIdentifier: String?

        fun build(): DescribeNodeConfigurationOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionType: ActionType? = null
        override var clusterIdentifier: String? = null
        override var filters: List<NodeConfigurationOptionsFilter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var ownerAccount: String? = null
        override var snapshotIdentifier: String? = null

        constructor(x: DescribeNodeConfigurationOptionsRequest) : this() {
            this.actionType = x.actionType
            this.clusterIdentifier = x.clusterIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.ownerAccount = x.ownerAccount
            this.snapshotIdentifier = x.snapshotIdentifier
        }

        override fun build(): DescribeNodeConfigurationOptionsRequest = DescribeNodeConfigurationOptionsRequest(this)
        override fun actionType(actionType: ActionType): FluentBuilder = apply { this.actionType = actionType }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun filters(filters: List<NodeConfigurationOptionsFilter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun ownerAccount(ownerAccount: String): FluentBuilder = apply { this.ownerAccount = ownerAccount }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
    }
}
