// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of logging for a cluster.
 */
class DescribeLoggingStatusResponse private constructor(builder: BuilderImpl) {
    /**
     * The name of the S3 bucket where the log files are stored.
     */
    val bucketName: String? = builder.bucketName
    /**
     * The message indicating that logs failed to be delivered.
     */
    val lastFailureMessage: String? = builder.lastFailureMessage
    /**
     * The last time when logs failed to be delivered.
     */
    val lastFailureTime: Instant? = builder.lastFailureTime
    /**
     * The last time that logs were delivered.
     */
    val lastSuccessfulDeliveryTime: Instant? = builder.lastSuccessfulDeliveryTime
    /**
     * true if logging is on, false if logging is off.
     */
    val loggingEnabled: Boolean = builder.loggingEnabled
    /**
     * The prefix applied to the log file names.
     */
    val s3KeyPrefix: String? = builder.s3KeyPrefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeLoggingStatusResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLoggingStatusResponse(")
        append("bucketName=$bucketName,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("lastFailureTime=$lastFailureTime,")
        append("lastSuccessfulDeliveryTime=$lastSuccessfulDeliveryTime,")
        append("loggingEnabled=$loggingEnabled,")
        append("s3KeyPrefix=$s3KeyPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (lastFailureTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulDeliveryTime?.hashCode() ?: 0)
        result = 31 * result + (loggingEnabled.hashCode())
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeLoggingStatusResponse

        if (bucketName != other.bucketName) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (lastFailureTime != other.lastFailureTime) return false
        if (lastSuccessfulDeliveryTime != other.lastSuccessfulDeliveryTime) return false
        if (loggingEnabled != other.loggingEnabled) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeLoggingStatusResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeLoggingStatusResponse
        /**
         * The name of the S3 bucket where the log files are stored.
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * The message indicating that logs failed to be delivered.
         */
        fun lastFailureMessage(lastFailureMessage: String): FluentBuilder
        /**
         * The last time when logs failed to be delivered.
         */
        fun lastFailureTime(lastFailureTime: Instant): FluentBuilder
        /**
         * The last time that logs were delivered.
         */
        fun lastSuccessfulDeliveryTime(lastSuccessfulDeliveryTime: Instant): FluentBuilder
        /**
         * true if logging is on, false if logging is off.
         */
        fun loggingEnabled(loggingEnabled: Boolean): FluentBuilder
        /**
         * The prefix applied to the log file names.
         */
        fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the S3 bucket where the log files are stored.
         */
        var bucketName: String?
        /**
         * The message indicating that logs failed to be delivered.
         */
        var lastFailureMessage: String?
        /**
         * The last time when logs failed to be delivered.
         */
        var lastFailureTime: Instant?
        /**
         * The last time that logs were delivered.
         */
        var lastSuccessfulDeliveryTime: Instant?
        /**
         * true if logging is on, false if logging is off.
         */
        var loggingEnabled: Boolean
        /**
         * The prefix applied to the log file names.
         */
        var s3KeyPrefix: String?

        fun build(): DescribeLoggingStatusResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketName: String? = null
        override var lastFailureMessage: String? = null
        override var lastFailureTime: Instant? = null
        override var lastSuccessfulDeliveryTime: Instant? = null
        override var loggingEnabled: Boolean = false
        override var s3KeyPrefix: String? = null

        constructor(x: DescribeLoggingStatusResponse) : this() {
            this.bucketName = x.bucketName
            this.lastFailureMessage = x.lastFailureMessage
            this.lastFailureTime = x.lastFailureTime
            this.lastSuccessfulDeliveryTime = x.lastSuccessfulDeliveryTime
            this.loggingEnabled = x.loggingEnabled
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        override fun build(): DescribeLoggingStatusResponse = DescribeLoggingStatusResponse(this)
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun lastFailureMessage(lastFailureMessage: String): FluentBuilder = apply { this.lastFailureMessage = lastFailureMessage }
        override fun lastFailureTime(lastFailureTime: Instant): FluentBuilder = apply { this.lastFailureTime = lastFailureTime }
        override fun lastSuccessfulDeliveryTime(lastSuccessfulDeliveryTime: Instant): FluentBuilder = apply { this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime }
        override fun loggingEnabled(loggingEnabled: Boolean): FluentBuilder = apply { this.loggingEnabled = loggingEnabled }
        override fun s3KeyPrefix(s3KeyPrefix: String): FluentBuilder = apply { this.s3KeyPrefix = s3KeyPrefix }
    }
}
