// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
class DescribeEventsRequest private constructor(builder: BuilderImpl) {
    /**
     * The number of minutes prior to the time of the request for which to retrieve
     * events. For example, if the request is sent at 18:00 and you specify a duration of 60,
     * then only events which have occurred after 17:00 will be returned.
     * Default: 60
     */
    val duration: Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601
     * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
     * Example: 2009-07-08T18:00Z
     */
    val endTime: Instant? = builder.endTime
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeEvents request exceed the value
     * specified in MaxRecords, Amazon Web Services returns a value in the Marker
     * field of the response. You can retrieve the next set of response records by providing
     * the returned marker value in the Marker parameter and retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The identifier of the event source for which events will be returned. If this
     * parameter is not specified, then all sources are included in the response.
     * Constraints:
     * If SourceIdentifier is supplied,
     * SourceType must also be provided.
     * Specify a cluster identifier when SourceType is
     * cluster.
     * Specify a cluster security group name when SourceType
     * is cluster-security-group.
     * Specify a cluster parameter group name when SourceType
     * is cluster-parameter-group.
     * Specify a cluster snapshot identifier when SourceType
     * is cluster-snapshot.
     */
    val sourceIdentifier: String? = builder.sourceIdentifier
    /**
     * The event source to retrieve events for. If no value is specified, all events are
     * returned.
     * Constraints:
     * If SourceType is supplied,
     * SourceIdentifier must also be provided.
     * Specify cluster when SourceIdentifier is
     * a cluster identifier.
     * Specify cluster-security-group when
     * SourceIdentifier is a cluster security group
     * name.
     * Specify cluster-parameter-group when
     * SourceIdentifier is a cluster parameter group
     * name.
     * Specify cluster-snapshot when
     * SourceIdentifier is a cluster snapshot
     * identifier.
     */
    val sourceType: SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601
     * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
     * Example: 2009-07-08T18:00Z
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeEventsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeEventsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeEventsRequest
        /**
         * The number of minutes prior to the time of the request for which to retrieve
         * events. For example, if the request is sent at 18:00 and you specify a duration of 60,
         * then only events which have occurred after 17:00 will be returned.
         * Default: 60
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601
         * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2009-07-08T18:00Z
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeEvents request exceed the value
         * specified in MaxRecords, Amazon Web Services returns a value in the Marker
         * field of the response. You can retrieve the next set of response records by providing
         * the returned marker value in the Marker parameter and retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The identifier of the event source for which events will be returned. If this
         * parameter is not specified, then all sources are included in the response.
         * Constraints:
         * If SourceIdentifier is supplied,
         * SourceType must also be provided.
         * Specify a cluster identifier when SourceType is
         * cluster.
         * Specify a cluster security group name when SourceType
         * is cluster-security-group.
         * Specify a cluster parameter group name when SourceType
         * is cluster-parameter-group.
         * Specify a cluster snapshot identifier when SourceType
         * is cluster-snapshot.
         */
        fun sourceIdentifier(sourceIdentifier: String): FluentBuilder
        /**
         * The event source to retrieve events for. If no value is specified, all events are
         * returned.
         * Constraints:
         * If SourceType is supplied,
         * SourceIdentifier must also be provided.
         * Specify cluster when SourceIdentifier is
         * a cluster identifier.
         * Specify cluster-security-group when
         * SourceIdentifier is a cluster security group
         * name.
         * Specify cluster-parameter-group when
         * SourceIdentifier is a cluster parameter group
         * name.
         * Specify cluster-snapshot when
         * SourceIdentifier is a cluster snapshot
         * identifier.
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601
         * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2009-07-08T18:00Z
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of minutes prior to the time of the request for which to retrieve
         * events. For example, if the request is sent at 18:00 and you specify a duration of 60,
         * then only events which have occurred after 17:00 will be returned.
         * Default: 60
         */
        var duration: Int?
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601
         * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2009-07-08T18:00Z
         */
        var endTime: Instant?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeEvents request exceed the value
         * specified in MaxRecords, Amazon Web Services returns a value in the Marker
         * field of the response. You can retrieve the next set of response records by providing
         * the returned marker value in the Marker parameter and retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The identifier of the event source for which events will be returned. If this
         * parameter is not specified, then all sources are included in the response.
         * Constraints:
         * If SourceIdentifier is supplied,
         * SourceType must also be provided.
         * Specify a cluster identifier when SourceType is
         * cluster.
         * Specify a cluster security group name when SourceType
         * is cluster-security-group.
         * Specify a cluster parameter group name when SourceType
         * is cluster-parameter-group.
         * Specify a cluster snapshot identifier when SourceType
         * is cluster-snapshot.
         */
        var sourceIdentifier: String?
        /**
         * The event source to retrieve events for. If no value is specified, all events are
         * returned.
         * Constraints:
         * If SourceType is supplied,
         * SourceIdentifier must also be provided.
         * Specify cluster when SourceIdentifier is
         * a cluster identifier.
         * Specify cluster-security-group when
         * SourceIdentifier is a cluster security group
         * name.
         * Specify cluster-parameter-group when
         * SourceIdentifier is a cluster parameter group
         * name.
         * Specify cluster-snapshot when
         * SourceIdentifier is a cluster snapshot
         * identifier.
         */
        var sourceType: SourceType?
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601
         * format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2009-07-08T18:00Z
         */
        var startTime: Instant?

        fun build(): DescribeEventsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var duration: Int? = null
        override var endTime: Instant? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var sourceIdentifier: String? = null
        override var sourceType: SourceType? = null
        override var startTime: Instant? = null

        constructor(x: DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        override fun build(): DescribeEventsRequest = DescribeEventsRequest(this)
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun sourceIdentifier(sourceIdentifier: String): FluentBuilder = apply { this.sourceIdentifier = sourceIdentifier }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
