// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeEndpointAuthorizationRequest private constructor(builder: BuilderImpl) {
    /**
     * The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
     * If Grantee parameter is true, then the Account value is of the grantor.
     */
    val account: String? = builder.account
    /**
     * The cluster identifier of the cluster to access.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * Indicates whether to check authorization from a grantor or grantee point of view.
     * If true, Amazon Redshift returns endpoint authorizations that you've been granted.
     * If false (default), checks authorization from a grantor point of view.
     */
    val grantee: Boolean? = builder.grantee
    /**
     * An optional pagination token provided by a previous
     * DescribeEndpointAuthorization request. If this parameter is specified, the
     * response includes only records beyond the marker, up to the value specified by the
     * MaxRecords parameter.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist
     * than the specified MaxRecords value, a pagination token called a Marker is
     * included in the response so that the remaining results can be retrieved.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeEndpointAuthorizationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEndpointAuthorizationRequest(")
        append("account=$account,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("grantee=$grantee,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEndpointAuthorizationRequest

        if (account != other.account) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (grantee != other.grantee) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeEndpointAuthorizationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeEndpointAuthorizationRequest
        /**
         * The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
         * If Grantee parameter is true, then the Account value is of the grantor.
         */
        fun account(account: String): FluentBuilder
        /**
         * The cluster identifier of the cluster to access.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * Indicates whether to check authorization from a grantor or grantee point of view.
         * If true, Amazon Redshift returns endpoint authorizations that you've been granted.
         * If false (default), checks authorization from a grantor point of view.
         */
        fun grantee(grantee: Boolean): FluentBuilder
        /**
         * An optional pagination token provided by a previous
         * DescribeEndpointAuthorization request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a Marker is
         * included in the response so that the remaining results can be retrieved.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
         * If Grantee parameter is true, then the Account value is of the grantor.
         */
        var account: String?
        /**
         * The cluster identifier of the cluster to access.
         */
        var clusterIdentifier: String?
        /**
         * Indicates whether to check authorization from a grantor or grantee point of view.
         * If true, Amazon Redshift returns endpoint authorizations that you've been granted.
         * If false (default), checks authorization from a grantor point of view.
         */
        var grantee: Boolean?
        /**
         * An optional pagination token provided by a previous
         * DescribeEndpointAuthorization request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a Marker is
         * included in the response so that the remaining results can be retrieved.
         */
        var maxRecords: Int?

        fun build(): DescribeEndpointAuthorizationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var account: String? = null
        override var clusterIdentifier: String? = null
        override var grantee: Boolean? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeEndpointAuthorizationRequest) : this() {
            this.account = x.account
            this.clusterIdentifier = x.clusterIdentifier
            this.grantee = x.grantee
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeEndpointAuthorizationRequest = DescribeEndpointAuthorizationRequest(this)
        override fun account(account: String): FluentBuilder = apply { this.account = account }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun grantee(grantee: Boolean): FluentBuilder = apply { this.grantee = grantee }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
