// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeEndpointAccessRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier associated with the described endpoint.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The name of the endpoint to be described.
     */
    val endpointName: String? = builder.endpointName
    /**
     * An optional pagination token provided by a previous
     * DescribeEndpointAccess request. If this parameter is specified, the
     * response includes only records beyond the marker, up to the value specified by the
     * MaxRecords parameter.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist
     * than the specified MaxRecords value, a pagination token called a Marker is
     * included in the response so that the remaining results can be retrieved.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The Amazon Web Services account ID of the owner of the cluster.
     */
    val resourceOwner: String? = builder.resourceOwner
    /**
     * The virtual private cloud (VPC) identifier with access to the cluster.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeEndpointAccessRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEndpointAccessRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endpointName=$endpointName,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("resourceOwner=$resourceOwner,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEndpointAccessRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endpointName != other.endpointName) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (resourceOwner != other.resourceOwner) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeEndpointAccessRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeEndpointAccessRequest
        /**
         * The cluster identifier associated with the described endpoint.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The name of the endpoint to be described.
         */
        fun endpointName(endpointName: String): FluentBuilder
        /**
         * An optional pagination token provided by a previous
         * DescribeEndpointAccess request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a Marker is
         * included in the response so that the remaining results can be retrieved.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The Amazon Web Services account ID of the owner of the cluster.
         */
        fun resourceOwner(resourceOwner: String): FluentBuilder
        /**
         * The virtual private cloud (VPC) identifier with access to the cluster.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier associated with the described endpoint.
         */
        var clusterIdentifier: String?
        /**
         * The name of the endpoint to be described.
         */
        var endpointName: String?
        /**
         * An optional pagination token provided by a previous
         * DescribeEndpointAccess request. If this parameter is specified, the
         * response includes only records beyond the marker, up to the value specified by the
         * MaxRecords parameter.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist
         * than the specified MaxRecords value, a pagination token called a Marker is
         * included in the response so that the remaining results can be retrieved.
         */
        var maxRecords: Int?
        /**
         * The Amazon Web Services account ID of the owner of the cluster.
         */
        var resourceOwner: String?
        /**
         * The virtual private cloud (VPC) identifier with access to the cluster.
         */
        var vpcId: String?

        fun build(): DescribeEndpointAccessRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var endpointName: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var resourceOwner: String? = null
        override var vpcId: String? = null

        constructor(x: DescribeEndpointAccessRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.endpointName = x.endpointName
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.resourceOwner = x.resourceOwner
            this.vpcId = x.vpcId
        }

        override fun build(): DescribeEndpointAccessRequest = DescribeEndpointAccessRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun endpointName(endpointName: String): FluentBuilder = apply { this.endpointName = endpointName }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun resourceOwner(resourceOwner: String): FluentBuilder = apply { this.resourceOwner = resourceOwner }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
