// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeDataSharesForProducerRequest private constructor(builder: BuilderImpl) {
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeDataSharesForProducer request
     * exceed the value specified in MaxRecords, AWS returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
     */
    val producerArn: String? = builder.producerArn
    /**
     * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
     * Redshift returns the list of datashares that have the specified status.
     */
    val status: DataShareStatusForProducer? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDataSharesForProducerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDataSharesForProducerRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("producerArn=$producerArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (producerArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDataSharesForProducerRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (producerArn != other.producerArn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDataSharesForProducerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDataSharesForProducerRequest
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeDataSharesForProducer request
         * exceed the value specified in MaxRecords, AWS returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
         */
        fun producerArn(producerArn: String): FluentBuilder
        /**
         * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
         * Redshift returns the list of datashares that have the specified status.
         */
        fun status(status: DataShareStatusForProducer): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeDataSharesForProducer request
         * exceed the value specified in MaxRecords, AWS returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        var maxRecords: Int?
        /**
         * The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.
         */
        var producerArn: String?
        /**
         * An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
         * Redshift returns the list of datashares that have the specified status.
         */
        var status: DataShareStatusForProducer?

        fun build(): DescribeDataSharesForProducerRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var producerArn: String? = null
        override var status: DataShareStatusForProducer? = null

        constructor(x: DescribeDataSharesForProducerRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.producerArn = x.producerArn
            this.status = x.status
        }

        override fun build(): DescribeDataSharesForProducerRequest = DescribeDataSharesForProducerRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun producerArn(producerArn: String): FluentBuilder = apply { this.producerArn = producerArn }
        override fun status(status: DataShareStatusForProducer): FluentBuilder = apply { this.status = status }
    }
}
