// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeDataSharesForConsumerRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.
     */
    val consumerArn: String? = builder.consumerArn
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeDataSharesForConsumer request
     * exceed the value specified in MaxRecords, AWS returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
     * Redshift returns the list of datashares that have the specified status.
     */
    val status: DataShareStatusForConsumer? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDataSharesForConsumerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDataSharesForConsumerRequest(")
        append("consumerArn=$consumerArn,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerArn?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDataSharesForConsumerRequest

        if (consumerArn != other.consumerArn) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDataSharesForConsumerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDataSharesForConsumerRequest
        /**
         * The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.
         */
        fun consumerArn(consumerArn: String): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeDataSharesForConsumer request
         * exceed the value specified in MaxRecords, AWS returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
         * Redshift returns the list of datashares that have the specified status.
         */
        fun status(status: DataShareStatusForConsumer): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.
         */
        var consumerArn: String?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeDataSharesForConsumer request
         * exceed the value specified in MaxRecords, AWS returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         */
        var maxRecords: Int?
        /**
         * An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
         * Redshift returns the list of datashares that have the specified status.
         */
        var status: DataShareStatusForConsumer?

        fun build(): DescribeDataSharesForConsumerRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var consumerArn: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var status: DataShareStatusForConsumer? = null

        constructor(x: DescribeDataSharesForConsumerRequest) : this() {
            this.consumerArn = x.consumerArn
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.status = x.status
        }

        override fun build(): DescribeDataSharesForConsumerRequest = DescribeDataSharesForConsumerRequest(this)
        override fun consumerArn(consumerArn: String): FluentBuilder = apply { this.consumerArn = consumerArn }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun status(status: DataShareStatusForConsumer): FluentBuilder = apply { this.status = status }
    }
}
