// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeClustersRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of a cluster whose properties you are requesting. This
     * parameter is case sensitive.
     * The default is that all clusters defined for an account are returned.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeClusters request exceed the
     * value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     * Constraints: You can specify either the ClusterIdentifier parameter or the Marker parameter, but not both.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * A tag key or keys for which you want to return all matching clusters that are
     * associated with the specified key or keys. For example, suppose that you have clusters
     * that are tagged with keys called owner and environment. If you
     * specify both of these tag keys in the request, Amazon Redshift returns a response with the
     * clusters that have either or both of these tag keys associated with them.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching clusters that are
     * associated with the specified tag value or values. For example, suppose that you have
     * clusters that are tagged with values called admin and test. If
     * you specify both of these tag values in the request, Amazon Redshift returns a response with
     * the clusters that have either or both of these tag values associated with
     * them.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClustersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClustersRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClustersRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClustersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClustersRequest
        /**
         * The unique identifier of a cluster whose properties you are requesting. This
         * parameter is case sensitive.
         * The default is that all clusters defined for an account are returned.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusters request exceed the
         * value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         * Constraints: You can specify either the ClusterIdentifier parameter or the Marker parameter, but not both.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * A tag key or keys for which you want to return all matching clusters that are
         * associated with the specified key or keys. For example, suppose that you have clusters
         * that are tagged with keys called owner and environment. If you
         * specify both of these tag keys in the request, Amazon Redshift returns a response with the
         * clusters that have either or both of these tag keys associated with them.
         */
        fun tagKeys(tagKeys: List<String>): FluentBuilder
        /**
         * A tag value or values for which you want to return all matching clusters that are
         * associated with the specified tag value or values. For example, suppose that you have
         * clusters that are tagged with values called admin and test. If
         * you specify both of these tag values in the request, Amazon Redshift returns a response with
         * the clusters that have either or both of these tag values associated with
         * them.
         */
        fun tagValues(tagValues: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of a cluster whose properties you are requesting. This
         * parameter is case sensitive.
         * The default is that all clusters defined for an account are returned.
         */
        var clusterIdentifier: String?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusters request exceed the
         * value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         * Constraints: You can specify either the ClusterIdentifier parameter or the Marker parameter, but not both.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * A tag key or keys for which you want to return all matching clusters that are
         * associated with the specified key or keys. For example, suppose that you have clusters
         * that are tagged with keys called owner and environment. If you
         * specify both of these tag keys in the request, Amazon Redshift returns a response with the
         * clusters that have either or both of these tag keys associated with them.
         */
        var tagKeys: List<String>?
        /**
         * A tag value or values for which you want to return all matching clusters that are
         * associated with the specified tag value or values. For example, suppose that you have
         * clusters that are tagged with values called admin and test. If
         * you specify both of these tag values in the request, Amazon Redshift returns a response with
         * the clusters that have either or both of these tag values associated with
         * them.
         */
        var tagValues: List<String>?

        fun build(): DescribeClustersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var tagKeys: List<String>? = null
        override var tagValues: List<String>? = null

        constructor(x: DescribeClustersRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        override fun build(): DescribeClustersRequest = DescribeClustersRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun tagKeys(tagKeys: List<String>): FluentBuilder = apply { this.tagKeys = tagKeys }
        override fun tagValues(tagValues: List<String>): FluentBuilder = apply { this.tagValues = tagValues }
    }
}
