// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeClusterVersionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of a specific cluster parameter group family to return details
     * for.
     * Constraints:
     * Must be 1 to 255 alphanumeric characters
     * First character must be a letter
     * Cannot end with a hyphen or contain two consecutive hyphens
     */
    val clusterParameterGroupFamily: String? = builder.clusterParameterGroupFamily
    /**
     * The specific cluster version to return.
     * Example: 1.0
     */
    val clusterVersion: String? = builder.clusterVersion
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeClusterVersions request exceed
     * the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClusterVersionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterVersionsRequest(")
        append("clusterParameterGroupFamily=$clusterParameterGroupFamily,")
        append("clusterVersion=$clusterVersion,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterParameterGroupFamily?.hashCode() ?: 0
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClusterVersionsRequest

        if (clusterParameterGroupFamily != other.clusterParameterGroupFamily) return false
        if (clusterVersion != other.clusterVersion) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClusterVersionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClusterVersionsRequest
        /**
         * The name of a specific cluster parameter group family to return details
         * for.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         */
        fun clusterParameterGroupFamily(clusterParameterGroupFamily: String): FluentBuilder
        /**
         * The specific cluster version to return.
         * Example: 1.0
         */
        fun clusterVersion(clusterVersion: String): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterVersions request exceed
         * the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of a specific cluster parameter group family to return details
         * for.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters
         * First character must be a letter
         * Cannot end with a hyphen or contain two consecutive hyphens
         */
        var clusterParameterGroupFamily: String?
        /**
         * The specific cluster version to return.
         * Example: 1.0
         */
        var clusterVersion: String?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterVersions request exceed
         * the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?

        fun build(): DescribeClusterVersionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterParameterGroupFamily: String? = null
        override var clusterVersion: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeClusterVersionsRequest) : this() {
            this.clusterParameterGroupFamily = x.clusterParameterGroupFamily
            this.clusterVersion = x.clusterVersion
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeClusterVersionsRequest = DescribeClusterVersionsRequest(this)
        override fun clusterParameterGroupFamily(clusterParameterGroupFamily: String): FluentBuilder = apply { this.clusterParameterGroupFamily = clusterParameterGroupFamily }
        override fun clusterVersion(clusterVersion: String): FluentBuilder = apply { this.clusterVersion = clusterVersion }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
