// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
class DescribeClusterSnapshotsRequest private constructor(builder: BuilderImpl) {
    /**
     * A value that indicates whether to return snapshots only for an existing cluster.
     * You can perform table-level restore only by using a snapshot of an existing cluster,
     * that is, a cluster that has not been deleted. Values for this parameter work as follows:
     * If ClusterExists is set to true,
     * ClusterIdentifier is required.
     * If ClusterExists is set to false and
     * ClusterIdentifier isn't specified, all snapshots
     * associated with deleted clusters (orphaned snapshots) are returned.
     * If ClusterExists is set to false and
     * ClusterIdentifier is specified for a deleted cluster, snapshots
     * associated with that cluster are returned.
     * If ClusterExists is set to false and
     * ClusterIdentifier is specified for an existing cluster, no
     * snapshots are returned.
     */
    val clusterExists: Boolean? = builder.clusterExists
    /**
     * The identifier of the cluster which generated the requested snapshots.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A time value that requests only snapshots created at or before the specified time.
     * The time value is specified in ISO 8601 format. For more information about ISO 8601, go
     * to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
     * page.
     * Example: 2012-07-16T18:00:00Z
     */
    val endTime: Instant? = builder.endTime
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeClusterSnapshots request exceed
     * the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The Amazon Web Services account used to create or copy the snapshot. Use this field to
     * filter the results to snapshots owned by a particular account. To describe snapshots you
     * own, either specify your Amazon Web Services account, or do not specify the
     * parameter.
     */
    val ownerAccount: String? = builder.ownerAccount
    /**
     * The snapshot identifier of the snapshot about which to return
     * information.
     */
    val snapshotIdentifier: String? = builder.snapshotIdentifier
    /**
     * The type of snapshots for which you are requesting information. By default,
     * snapshots of all types are returned.
     * Valid Values: automated | manual
     */
    val snapshotType: String? = builder.snapshotType
    /**
     *
     */
    val sortingEntities: List<SnapshotSortingEntity>? = builder.sortingEntities
    /**
     * A value that requests only snapshots created at or after the specified time. The
     * time value is specified in ISO 8601 format. For more information about ISO 8601, go to
     * the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
     * Example: 2012-07-16T18:00:00Z
     */
    val startTime: Instant? = builder.startTime
    /**
     * A tag key or keys for which you want to return all matching cluster snapshots that
     * are associated with the specified key or keys. For example, suppose that you have
     * snapshots that are tagged with keys called owner and
     * environment. If you specify both of these tag keys in the request,
     * Amazon Redshift returns a response with the snapshots that have either or both of these tag
     * keys associated with them.
     */
    val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching cluster snapshots
     * that are associated with the specified tag value or values. For example, suppose that
     * you have snapshots that are tagged with values called admin and
     * test. If you specify both of these tag values in the request, Amazon Redshift
     * returns a response with the snapshots that have either or both of these tag values
     * associated with them.
     */
    val tagValues: List<String>? = builder.tagValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClusterSnapshotsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterSnapshotsRequest(")
        append("clusterExists=$clusterExists,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endTime=$endTime,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotType=$snapshotType,")
        append("sortingEntities=$sortingEntities,")
        append("startTime=$startTime,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterExists?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sortingEntities?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClusterSnapshotsRequest

        if (clusterExists != other.clusterExists) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endTime != other.endTime) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotType != other.snapshotType) return false
        if (sortingEntities != other.sortingEntities) return false
        if (startTime != other.startTime) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClusterSnapshotsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClusterSnapshotsRequest
        /**
         * A value that indicates whether to return snapshots only for an existing cluster.
         * You can perform table-level restore only by using a snapshot of an existing cluster,
         * that is, a cluster that has not been deleted. Values for this parameter work as follows:
         * If ClusterExists is set to true,
         * ClusterIdentifier is required.
         * If ClusterExists is set to false and
         * ClusterIdentifier isn't specified, all snapshots
         * associated with deleted clusters (orphaned snapshots) are returned.
         * If ClusterExists is set to false and
         * ClusterIdentifier is specified for a deleted cluster, snapshots
         * associated with that cluster are returned.
         * If ClusterExists is set to false and
         * ClusterIdentifier is specified for an existing cluster, no
         * snapshots are returned.
         */
        fun clusterExists(clusterExists: Boolean): FluentBuilder
        /**
         * The identifier of the cluster which generated the requested snapshots.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A time value that requests only snapshots created at or before the specified time.
         * The time value is specified in ISO 8601 format. For more information about ISO 8601, go
         * to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
         * page.
         * Example: 2012-07-16T18:00:00Z
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterSnapshots request exceed
         * the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Use this field to
         * filter the results to snapshots owned by a particular account. To describe snapshots you
         * own, either specify your Amazon Web Services account, or do not specify the
         * parameter.
         */
        fun ownerAccount(ownerAccount: String): FluentBuilder
        /**
         * The snapshot identifier of the snapshot about which to return
         * information.
         */
        fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder
        /**
         * The type of snapshots for which you are requesting information. By default,
         * snapshots of all types are returned.
         * Valid Values: automated | manual
         */
        fun snapshotType(snapshotType: String): FluentBuilder
        /**
         *
         */
        fun sortingEntities(sortingEntities: List<SnapshotSortingEntity>): FluentBuilder
        /**
         * A value that requests only snapshots created at or after the specified time. The
         * time value is specified in ISO 8601 format. For more information about ISO 8601, go to
         * the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2012-07-16T18:00:00Z
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * A tag key or keys for which you want to return all matching cluster snapshots that
         * are associated with the specified key or keys. For example, suppose that you have
         * snapshots that are tagged with keys called owner and
         * environment. If you specify both of these tag keys in the request,
         * Amazon Redshift returns a response with the snapshots that have either or both of these tag
         * keys associated with them.
         */
        fun tagKeys(tagKeys: List<String>): FluentBuilder
        /**
         * A tag value or values for which you want to return all matching cluster snapshots
         * that are associated with the specified tag value or values. For example, suppose that
         * you have snapshots that are tagged with values called admin and
         * test. If you specify both of these tag values in the request, Amazon Redshift
         * returns a response with the snapshots that have either or both of these tag values
         * associated with them.
         */
        fun tagValues(tagValues: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that indicates whether to return snapshots only for an existing cluster.
         * You can perform table-level restore only by using a snapshot of an existing cluster,
         * that is, a cluster that has not been deleted. Values for this parameter work as follows:
         * If ClusterExists is set to true,
         * ClusterIdentifier is required.
         * If ClusterExists is set to false and
         * ClusterIdentifier isn't specified, all snapshots
         * associated with deleted clusters (orphaned snapshots) are returned.
         * If ClusterExists is set to false and
         * ClusterIdentifier is specified for a deleted cluster, snapshots
         * associated with that cluster are returned.
         * If ClusterExists is set to false and
         * ClusterIdentifier is specified for an existing cluster, no
         * snapshots are returned.
         */
        var clusterExists: Boolean?
        /**
         * The identifier of the cluster which generated the requested snapshots.
         */
        var clusterIdentifier: String?
        /**
         * A time value that requests only snapshots created at or before the specified time.
         * The time value is specified in ISO 8601 format. For more information about ISO 8601, go
         * to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
         * page.
         * Example: 2012-07-16T18:00:00Z
         */
        var endTime: Instant?
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterSnapshots request exceed
         * the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Use this field to
         * filter the results to snapshots owned by a particular account. To describe snapshots you
         * own, either specify your Amazon Web Services account, or do not specify the
         * parameter.
         */
        var ownerAccount: String?
        /**
         * The snapshot identifier of the snapshot about which to return
         * information.
         */
        var snapshotIdentifier: String?
        /**
         * The type of snapshots for which you are requesting information. By default,
         * snapshots of all types are returned.
         * Valid Values: automated | manual
         */
        var snapshotType: String?
        /**
         *
         */
        var sortingEntities: List<SnapshotSortingEntity>?
        /**
         * A value that requests only snapshots created at or after the specified time. The
         * time value is specified in ISO 8601 format. For more information about ISO 8601, go to
         * the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.
         * Example: 2012-07-16T18:00:00Z
         */
        var startTime: Instant?
        /**
         * A tag key or keys for which you want to return all matching cluster snapshots that
         * are associated with the specified key or keys. For example, suppose that you have
         * snapshots that are tagged with keys called owner and
         * environment. If you specify both of these tag keys in the request,
         * Amazon Redshift returns a response with the snapshots that have either or both of these tag
         * keys associated with them.
         */
        var tagKeys: List<String>?
        /**
         * A tag value or values for which you want to return all matching cluster snapshots
         * that are associated with the specified tag value or values. For example, suppose that
         * you have snapshots that are tagged with values called admin and
         * test. If you specify both of these tag values in the request, Amazon Redshift
         * returns a response with the snapshots that have either or both of these tag values
         * associated with them.
         */
        var tagValues: List<String>?

        fun build(): DescribeClusterSnapshotsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterExists: Boolean? = null
        override var clusterIdentifier: String? = null
        override var endTime: Instant? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var ownerAccount: String? = null
        override var snapshotIdentifier: String? = null
        override var snapshotType: String? = null
        override var sortingEntities: List<SnapshotSortingEntity>? = null
        override var startTime: Instant? = null
        override var tagKeys: List<String>? = null
        override var tagValues: List<String>? = null

        constructor(x: DescribeClusterSnapshotsRequest) : this() {
            this.clusterExists = x.clusterExists
            this.clusterIdentifier = x.clusterIdentifier
            this.endTime = x.endTime
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.ownerAccount = x.ownerAccount
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotType = x.snapshotType
            this.sortingEntities = x.sortingEntities
            this.startTime = x.startTime
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        override fun build(): DescribeClusterSnapshotsRequest = DescribeClusterSnapshotsRequest(this)
        override fun clusterExists(clusterExists: Boolean): FluentBuilder = apply { this.clusterExists = clusterExists }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun ownerAccount(ownerAccount: String): FluentBuilder = apply { this.ownerAccount = ownerAccount }
        override fun snapshotIdentifier(snapshotIdentifier: String): FluentBuilder = apply { this.snapshotIdentifier = snapshotIdentifier }
        override fun snapshotType(snapshotType: String): FluentBuilder = apply { this.snapshotType = snapshotType }
        override fun sortingEntities(sortingEntities: List<SnapshotSortingEntity>): FluentBuilder = apply { this.sortingEntities = sortingEntities }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun tagKeys(tagKeys: List<String>): FluentBuilder = apply { this.tagKeys = tagKeys }
        override fun tagValues(tagValues: List<String>): FluentBuilder = apply { this.tagValues = tagValues }
    }
}
