// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DescribeClusterParametersRequest private constructor(builder: BuilderImpl) {
    /**
     * An optional parameter that specifies the starting point to return a set of response
     * records. When the results of a DescribeClusterParameters request
     * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
     * Marker field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the Marker parameter and
     * retrying the request.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value
     * is returned in a marker field of the response. You can retrieve the next
     * set of records by retrying the command with the returned marker value.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The name of a cluster parameter group for which to return details.
     */
    val parameterGroupName: String? = builder.parameterGroupName
    /**
     * The parameter types to return. Specify user to show parameters that
     * are different form the default. Similarly, specify engine-default to show
     * parameters that are the same as the default parameter group.
     * Default: All parameter types returned.
     * Valid Values: user | engine-default
     */
    val source: String? = builder.source

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClusterParametersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterParametersRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("parameterGroupName=$parameterGroupName,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (parameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClusterParametersRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (parameterGroupName != other.parameterGroupName) return false
        if (source != other.source) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClusterParametersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClusterParametersRequest
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterParameters request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The name of a cluster parameter group for which to return details.
         */
        fun parameterGroupName(parameterGroupName: String): FluentBuilder
        /**
         * The parameter types to return. Specify user to show parameters that
         * are different form the default. Similarly, specify engine-default to show
         * parameters that are the same as the default parameter group.
         * Default: All parameter types returned.
         * Valid Values: user | engine-default
         */
        fun source(source: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An optional parameter that specifies the starting point to return a set of response
         * records. When the results of a DescribeClusterParameters request
         * exceed the value specified in MaxRecords, Amazon Web Services returns a value in the
         * Marker field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the Marker parameter and
         * retrying the request.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value
         * is returned in a marker field of the response. You can retrieve the next
         * set of records by retrying the command with the returned marker value.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The name of a cluster parameter group for which to return details.
         */
        var parameterGroupName: String?
        /**
         * The parameter types to return. Specify user to show parameters that
         * are different form the default. Similarly, specify engine-default to show
         * parameters that are the same as the default parameter group.
         * Default: All parameter types returned.
         * Valid Values: user | engine-default
         */
        var source: String?

        fun build(): DescribeClusterParametersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var parameterGroupName: String? = null
        override var source: String? = null

        constructor(x: DescribeClusterParametersRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.parameterGroupName = x.parameterGroupName
            this.source = x.source
        }

        override fun build(): DescribeClusterParametersRequest = DescribeClusterParametersRequest(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun parameterGroupName(parameterGroupName: String): FluentBuilder = apply { this.parameterGroupName = parameterGroupName }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
    }
}
