// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class DescribeClusterDbRevisionsRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique identifier for a cluster whose ClusterDbRevisions you are
     * requesting. This parameter is case sensitive. All clusters defined for an account are
     * returned by default.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * An optional parameter that specifies the starting point for returning a set of
     * response records. When the results of a DescribeClusterDbRevisions request
     * exceed the value specified in MaxRecords, Amazon Redshift returns a value
     * in the marker field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the
     * marker parameter and retrying the request.
     * Constraints: You can specify either the ClusterIdentifier parameter, or
     * the marker parameter, but not both.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of
     * remaining response records exceeds the specified MaxRecords value, a value is returned
     * in the marker field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the
     * marker parameter and retrying the request.
     * Default: 100
     * Constraints: minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClusterDbRevisionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterDbRevisionsRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClusterDbRevisionsRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClusterDbRevisionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClusterDbRevisionsRequest
        /**
         * A unique identifier for a cluster whose ClusterDbRevisions you are
         * requesting. This parameter is case sensitive. All clusters defined for an account are
         * returned by default.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * An optional parameter that specifies the starting point for returning a set of
         * response records. When the results of a DescribeClusterDbRevisions request
         * exceed the value specified in MaxRecords, Amazon Redshift returns a value
         * in the marker field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the
         * marker parameter and retrying the request.
         * Constraints: You can specify either the ClusterIdentifier parameter, or
         * the marker parameter, but not both.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value is returned
         * in the marker field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the
         * marker parameter and retrying the request.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique identifier for a cluster whose ClusterDbRevisions you are
         * requesting. This parameter is case sensitive. All clusters defined for an account are
         * returned by default.
         */
        var clusterIdentifier: String?
        /**
         * An optional parameter that specifies the starting point for returning a set of
         * response records. When the results of a DescribeClusterDbRevisions request
         * exceed the value specified in MaxRecords, Amazon Redshift returns a value
         * in the marker field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the
         * marker parameter and retrying the request.
         * Constraints: You can specify either the ClusterIdentifier parameter, or
         * the marker parameter, but not both.
         */
        var marker: String?
        /**
         * The maximum number of response records to return in each call. If the number of
         * remaining response records exceeds the specified MaxRecords value, a value is returned
         * in the marker field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the
         * marker parameter and retrying the request.
         * Default: 100
         * Constraints: minimum 20, maximum 100.
         */
        var maxRecords: Int?

        fun build(): DescribeClusterDbRevisionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeClusterDbRevisionsRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeClusterDbRevisionsRequest = DescribeClusterDbRevisionsRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
