// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class DeleteClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the cluster to be deleted.
     * Constraints:
     * Must contain lowercase characters.
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The identifier of the final snapshot that is to be created immediately before
     * deleting the cluster. If this parameter is provided,
     * SkipFinalClusterSnapshot must be false.
     * Constraints:
     * Must be 1 to 255 alphanumeric characters.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val finalClusterSnapshotIdentifier: String? = builder.finalClusterSnapshotIdentifier
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual
     * snapshot is retained indefinitely.
     * The value must be either -1 or an integer between 1 and 3,653.
     * The default value is -1.
     */
    val finalClusterSnapshotRetentionPeriod: Int? = builder.finalClusterSnapshotRetentionPeriod
    /**
     * Determines whether a final snapshot of the cluster is created before Amazon Redshift
     * deletes the cluster. If true, a final cluster snapshot is not created. If
     * false, a final cluster snapshot is created before the cluster is
     * deleted.
     * The FinalClusterSnapshotIdentifier parameter must be
     * specified if SkipFinalClusterSnapshot is
     * false.
     * Default: false
     */
    val skipFinalClusterSnapshot: Boolean = builder.skipFinalClusterSnapshot

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteClusterRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("finalClusterSnapshotIdentifier=$finalClusterSnapshotIdentifier,")
        append("finalClusterSnapshotRetentionPeriod=$finalClusterSnapshotRetentionPeriod,")
        append("skipFinalClusterSnapshot=$skipFinalClusterSnapshot)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (finalClusterSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (skipFinalClusterSnapshot.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteClusterRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (finalClusterSnapshotIdentifier != other.finalClusterSnapshotIdentifier) return false
        if (finalClusterSnapshotRetentionPeriod != other.finalClusterSnapshotRetentionPeriod) return false
        if (skipFinalClusterSnapshot != other.skipFinalClusterSnapshot) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteClusterRequest
        /**
         * The identifier of the cluster to be deleted.
         * Constraints:
         * Must contain lowercase characters.
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The identifier of the final snapshot that is to be created immediately before
         * deleting the cluster. If this parameter is provided,
         * SkipFinalClusterSnapshot must be false.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun finalClusterSnapshotIdentifier(finalClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        fun finalClusterSnapshotRetentionPeriod(finalClusterSnapshotRetentionPeriod: Int): FluentBuilder
        /**
         * Determines whether a final snapshot of the cluster is created before Amazon Redshift
         * deletes the cluster. If true, a final cluster snapshot is not created. If
         * false, a final cluster snapshot is created before the cluster is
         * deleted.
         * The FinalClusterSnapshotIdentifier parameter must be
         * specified if SkipFinalClusterSnapshot is
         * false.
         * Default: false
         */
        fun skipFinalClusterSnapshot(skipFinalClusterSnapshot: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the cluster to be deleted.
         * Constraints:
         * Must contain lowercase characters.
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var clusterIdentifier: String?
        /**
         * The identifier of the final snapshot that is to be created immediately before
         * deleting the cluster. If this parameter is provided,
         * SkipFinalClusterSnapshot must be false.
         * Constraints:
         * Must be 1 to 255 alphanumeric characters.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var finalClusterSnapshotIdentifier: String?
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual
         * snapshot is retained indefinitely.
         * The value must be either -1 or an integer between 1 and 3,653.
         * The default value is -1.
         */
        var finalClusterSnapshotRetentionPeriod: Int?
        /**
         * Determines whether a final snapshot of the cluster is created before Amazon Redshift
         * deletes the cluster. If true, a final cluster snapshot is not created. If
         * false, a final cluster snapshot is created before the cluster is
         * deleted.
         * The FinalClusterSnapshotIdentifier parameter must be
         * specified if SkipFinalClusterSnapshot is
         * false.
         * Default: false
         */
        var skipFinalClusterSnapshot: Boolean

        fun build(): DeleteClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var finalClusterSnapshotIdentifier: String? = null
        override var finalClusterSnapshotRetentionPeriod: Int? = null
        override var skipFinalClusterSnapshot: Boolean = false

        constructor(x: DeleteClusterRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.finalClusterSnapshotIdentifier = x.finalClusterSnapshotIdentifier
            this.finalClusterSnapshotRetentionPeriod = x.finalClusterSnapshotRetentionPeriod
            this.skipFinalClusterSnapshot = x.skipFinalClusterSnapshot
        }

        override fun build(): DeleteClusterRequest = DeleteClusterRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun finalClusterSnapshotIdentifier(finalClusterSnapshotIdentifier: String): FluentBuilder = apply { this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier }
        override fun finalClusterSnapshotRetentionPeriod(finalClusterSnapshotRetentionPeriod: Int): FluentBuilder = apply { this.finalClusterSnapshotRetentionPeriod = finalClusterSnapshotRetentionPeriod }
        override fun skipFinalClusterSnapshot(skipFinalClusterSnapshot: Boolean): FluentBuilder = apply { this.skipFinalClusterSnapshot = skipFinalClusterSnapshot }
    }
}
