// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the default cluster parameters for a parameter group family.
 */
class DefaultClusterParameters private constructor(builder: BuilderImpl) {
    /**
     * A value that indicates the starting point for the next set of response records in a
     * subsequent request. If a value is returned in a response, you can retrieve the next set
     * of records by providing this returned marker value in the Marker parameter
     * and retrying the command. If the Marker field is empty, all response
     * records have been retrieved for the request.
     */
    val marker: String? = builder.marker
    /**
     * The name of the cluster parameter group family to which the engine default
     * parameters apply.
     */
    val parameterGroupFamily: String? = builder.parameterGroupFamily
    /**
     * The list of cluster default parameters.
     */
    val parameters: List<Parameter>? = builder.parameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DefaultClusterParameters = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultClusterParameters(")
        append("marker=$marker,")
        append("parameterGroupFamily=$parameterGroupFamily,")
        append("parameters=$parameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (parameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DefaultClusterParameters

        if (marker != other.marker) return false
        if (parameterGroupFamily != other.parameterGroupFamily) return false
        if (parameters != other.parameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DefaultClusterParameters = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DefaultClusterParameters
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the Marker parameter
         * and retrying the command. If the Marker field is empty, all response
         * records have been retrieved for the request.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The name of the cluster parameter group family to which the engine default
         * parameters apply.
         */
        fun parameterGroupFamily(parameterGroupFamily: String): FluentBuilder
        /**
         * The list of cluster default parameters.
         */
        fun parameters(parameters: List<Parameter>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that indicates the starting point for the next set of response records in a
         * subsequent request. If a value is returned in a response, you can retrieve the next set
         * of records by providing this returned marker value in the Marker parameter
         * and retrying the command. If the Marker field is empty, all response
         * records have been retrieved for the request.
         */
        var marker: String?
        /**
         * The name of the cluster parameter group family to which the engine default
         * parameters apply.
         */
        var parameterGroupFamily: String?
        /**
         * The list of cluster default parameters.
         */
        var parameters: List<Parameter>?

        fun build(): DefaultClusterParameters
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var marker: String? = null
        override var parameterGroupFamily: String? = null
        override var parameters: List<Parameter>? = null

        constructor(x: DefaultClusterParameters) : this() {
            this.marker = x.marker
            this.parameterGroupFamily = x.parameterGroupFamily
            this.parameters = x.parameters
        }

        override fun build(): DefaultClusterParameters = DefaultClusterParameters(this)
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun parameterGroupFamily(parameterGroupFamily: String): FluentBuilder = apply { this.parameterGroupFamily = parameterGroupFamily }
        override fun parameters(parameters: List<Parameter>): FluentBuilder = apply { this.parameters = parameters }
    }
}
