// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes the status of a cluster while it is in the process of resizing with an
 * incremental resize.
 */
class DataTransferProgress private constructor(builder: BuilderImpl) {
    /**
     * Describes the data transfer rate in MB's per second.
     */
    val currentRateInMegaBytesPerSecond: Double? = builder.currentRateInMegaBytesPerSecond
    /**
     * Describes the total amount of data that has been transfered in MB's.
     */
    val dataTransferredInMegaBytes: Long = builder.dataTransferredInMegaBytes
    /**
     * Describes the number of seconds that have elapsed during the data transfer.
     */
    val elapsedTimeInSeconds: Long? = builder.elapsedTimeInSeconds
    /**
     * Describes the estimated number of seconds remaining to complete the transfer.
     */
    val estimatedTimeToCompletionInSeconds: Long? = builder.estimatedTimeToCompletionInSeconds
    /**
     * Describes the status of the cluster. While the transfer is in progress the status is
     * transferringdata.
     */
    val status: String? = builder.status
    /**
     * Describes the total amount of data to be transfered in megabytes.
     */
    val totalDataInMegaBytes: Long = builder.totalDataInMegaBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DataTransferProgress = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DataTransferProgress(")
        append("currentRateInMegaBytesPerSecond=$currentRateInMegaBytesPerSecond,")
        append("dataTransferredInMegaBytes=$dataTransferredInMegaBytes,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedTimeToCompletionInSeconds=$estimatedTimeToCompletionInSeconds,")
        append("status=$status,")
        append("totalDataInMegaBytes=$totalDataInMegaBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentRateInMegaBytesPerSecond?.hashCode() ?: 0
        result = 31 * result + (dataTransferredInMegaBytes.hashCode())
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (estimatedTimeToCompletionInSeconds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalDataInMegaBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DataTransferProgress

        if (currentRateInMegaBytesPerSecond != other.currentRateInMegaBytesPerSecond) return false
        if (dataTransferredInMegaBytes != other.dataTransferredInMegaBytes) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedTimeToCompletionInSeconds != other.estimatedTimeToCompletionInSeconds) return false
        if (status != other.status) return false
        if (totalDataInMegaBytes != other.totalDataInMegaBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DataTransferProgress = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DataTransferProgress
        /**
         * Describes the data transfer rate in MB's per second.
         */
        fun currentRateInMegaBytesPerSecond(currentRateInMegaBytesPerSecond: Double): FluentBuilder
        /**
         * Describes the total amount of data that has been transfered in MB's.
         */
        fun dataTransferredInMegaBytes(dataTransferredInMegaBytes: Long): FluentBuilder
        /**
         * Describes the number of seconds that have elapsed during the data transfer.
         */
        fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder
        /**
         * Describes the estimated number of seconds remaining to complete the transfer.
         */
        fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder
        /**
         * Describes the status of the cluster. While the transfer is in progress the status is
         * transferringdata.
         */
        fun status(status: String): FluentBuilder
        /**
         * Describes the total amount of data to be transfered in megabytes.
         */
        fun totalDataInMegaBytes(totalDataInMegaBytes: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Describes the data transfer rate in MB's per second.
         */
        var currentRateInMegaBytesPerSecond: Double?
        /**
         * Describes the total amount of data that has been transfered in MB's.
         */
        var dataTransferredInMegaBytes: Long
        /**
         * Describes the number of seconds that have elapsed during the data transfer.
         */
        var elapsedTimeInSeconds: Long?
        /**
         * Describes the estimated number of seconds remaining to complete the transfer.
         */
        var estimatedTimeToCompletionInSeconds: Long?
        /**
         * Describes the status of the cluster. While the transfer is in progress the status is
         * transferringdata.
         */
        var status: String?
        /**
         * Describes the total amount of data to be transfered in megabytes.
         */
        var totalDataInMegaBytes: Long

        fun build(): DataTransferProgress
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currentRateInMegaBytesPerSecond: Double? = null
        override var dataTransferredInMegaBytes: Long = 0L
        override var elapsedTimeInSeconds: Long? = null
        override var estimatedTimeToCompletionInSeconds: Long? = null
        override var status: String? = null
        override var totalDataInMegaBytes: Long = 0L

        constructor(x: DataTransferProgress) : this() {
            this.currentRateInMegaBytesPerSecond = x.currentRateInMegaBytesPerSecond
            this.dataTransferredInMegaBytes = x.dataTransferredInMegaBytes
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedTimeToCompletionInSeconds = x.estimatedTimeToCompletionInSeconds
            this.status = x.status
            this.totalDataInMegaBytes = x.totalDataInMegaBytes
        }

        override fun build(): DataTransferProgress = DataTransferProgress(this)
        override fun currentRateInMegaBytesPerSecond(currentRateInMegaBytesPerSecond: Double): FluentBuilder = apply { this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond }
        override fun dataTransferredInMegaBytes(dataTransferredInMegaBytes: Long): FluentBuilder = apply { this.dataTransferredInMegaBytes = dataTransferredInMegaBytes }
        override fun elapsedTimeInSeconds(elapsedTimeInSeconds: Long): FluentBuilder = apply { this.elapsedTimeInSeconds = elapsedTimeInSeconds }
        override fun estimatedTimeToCompletionInSeconds(estimatedTimeToCompletionInSeconds: Long): FluentBuilder = apply { this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun totalDataInMegaBytes(totalDataInMegaBytes: Long): FluentBuilder = apply { this.totalDataInMegaBytes = totalDataInMegaBytes }
    }
}
