// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The association of a datashare from a producer account with a data consumer.
 */
class DataShareAssociation private constructor(builder: BuilderImpl) {
    /**
     * The name of the consumer accounts that have an association with a producer
     * datashare.
     */
    val consumerIdentifier: String? = builder.consumerIdentifier
    /**
     * The creation date of the datashare that is associated.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The status of the datashare that is associated.
     */
    val status: DataShareStatus? = builder.status
    /**
     * The status change data of the datashare that is associated.
     */
    val statusChangeDate: Instant? = builder.statusChangeDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DataShareAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DataShareAssociation(")
        append("consumerIdentifier=$consumerIdentifier,")
        append("createdDate=$createdDate,")
        append("status=$status,")
        append("statusChangeDate=$statusChangeDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerIdentifier?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusChangeDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DataShareAssociation

        if (consumerIdentifier != other.consumerIdentifier) return false
        if (createdDate != other.createdDate) return false
        if (status != other.status) return false
        if (statusChangeDate != other.statusChangeDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DataShareAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DataShareAssociation
        /**
         * The name of the consumer accounts that have an association with a producer
         * datashare.
         */
        fun consumerIdentifier(consumerIdentifier: String): FluentBuilder
        /**
         * The creation date of the datashare that is associated.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The status of the datashare that is associated.
         */
        fun status(status: DataShareStatus): FluentBuilder
        /**
         * The status change data of the datashare that is associated.
         */
        fun statusChangeDate(statusChangeDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the consumer accounts that have an association with a producer
         * datashare.
         */
        var consumerIdentifier: String?
        /**
         * The creation date of the datashare that is associated.
         */
        var createdDate: Instant?
        /**
         * The status of the datashare that is associated.
         */
        var status: DataShareStatus?
        /**
         * The status change data of the datashare that is associated.
         */
        var statusChangeDate: Instant?

        fun build(): DataShareAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var consumerIdentifier: String? = null
        override var createdDate: Instant? = null
        override var status: DataShareStatus? = null
        override var statusChangeDate: Instant? = null

        constructor(x: DataShareAssociation) : this() {
            this.consumerIdentifier = x.consumerIdentifier
            this.createdDate = x.createdDate
            this.status = x.status
            this.statusChangeDate = x.statusChangeDate
        }

        override fun build(): DataShareAssociation = DataShareAssociation(this)
        override fun consumerIdentifier(consumerIdentifier: String): FluentBuilder = apply { this.consumerIdentifier = consumerIdentifier }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun status(status: DataShareStatus): FluentBuilder = apply { this.status = status }
        override fun statusChangeDate(statusChangeDate: Instant): FluentBuilder = apply { this.statusChangeDate = statusChangeDate }
    }
}
