// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



class CreateUsageLimitRequest private constructor(builder: BuilderImpl) {
    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
     * The value must be a positive number.
     */
    val amount: Long = builder.amount
    /**
     * The action that Amazon Redshift takes when the limit is reached. The default is log.
     * For more information about this parameter, see UsageLimit.
     */
    val breachAction: UsageLimitBreachAction? = builder.breachAction
    /**
     * The identifier of the cluster that you want to limit usage.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * The Amazon Redshift feature that you want to limit.
     */
    val featureType: UsageLimitFeatureType? = builder.featureType
    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
     * If FeatureType is spectrum, then LimitType must be data-scanned.
     * If FeatureType is concurrency-scaling, then LimitType must be time.
     */
    val limitType: UsageLimitLimitType? = builder.limitType
    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     */
    val period: UsageLimitPeriod? = builder.period
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateUsageLimitRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsageLimitRequest(")
        append("amount=$amount,")
        append("breachAction=$breachAction,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("featureType=$featureType,")
        append("limitType=$limitType,")
        append("period=$period,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amount.hashCode()
        result = 31 * result + (breachAction?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (featureType?.hashCode() ?: 0)
        result = 31 * result + (limitType?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateUsageLimitRequest

        if (amount != other.amount) return false
        if (breachAction != other.breachAction) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (featureType != other.featureType) return false
        if (limitType != other.limitType) return false
        if (period != other.period) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateUsageLimitRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateUsageLimitRequest
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         * The value must be a positive number.
         */
        fun amount(amount: Long): FluentBuilder
        /**
         * The action that Amazon Redshift takes when the limit is reached. The default is log.
         * For more information about this parameter, see UsageLimit.
         */
        fun breachAction(breachAction: UsageLimitBreachAction): FluentBuilder
        /**
         * The identifier of the cluster that you want to limit usage.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * The Amazon Redshift feature that you want to limit.
         */
        fun featureType(featureType: UsageLimitFeatureType): FluentBuilder
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * If FeatureType is spectrum, then LimitType must be data-scanned.
         * If FeatureType is concurrency-scaling, then LimitType must be time.
         */
        fun limitType(limitType: UsageLimitLimitType): FluentBuilder
        /**
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         */
        fun period(period: UsageLimitPeriod): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
         * The value must be a positive number.
         */
        var amount: Long
        /**
         * The action that Amazon Redshift takes when the limit is reached. The default is log.
         * For more information about this parameter, see UsageLimit.
         */
        var breachAction: UsageLimitBreachAction?
        /**
         * The identifier of the cluster that you want to limit usage.
         */
        var clusterIdentifier: String?
        /**
         * The Amazon Redshift feature that you want to limit.
         */
        var featureType: UsageLimitFeatureType?
        /**
         * The type of limit. Depending on the feature type, this can be based on a time duration or data size.
         * If FeatureType is spectrum, then LimitType must be data-scanned.
         * If FeatureType is concurrency-scaling, then LimitType must be time.
         */
        var limitType: UsageLimitLimitType?
        /**
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         */
        var period: UsageLimitPeriod?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): CreateUsageLimitRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amount: Long = 0L
        override var breachAction: UsageLimitBreachAction? = null
        override var clusterIdentifier: String? = null
        override var featureType: UsageLimitFeatureType? = null
        override var limitType: UsageLimitLimitType? = null
        override var period: UsageLimitPeriod? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateUsageLimitRequest) : this() {
            this.amount = x.amount
            this.breachAction = x.breachAction
            this.clusterIdentifier = x.clusterIdentifier
            this.featureType = x.featureType
            this.limitType = x.limitType
            this.period = x.period
            this.tags = x.tags
        }

        override fun build(): CreateUsageLimitRequest = CreateUsageLimitRequest(this)
        override fun amount(amount: Long): FluentBuilder = apply { this.amount = amount }
        override fun breachAction(breachAction: UsageLimitBreachAction): FluentBuilder = apply { this.breachAction = breachAction }
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun featureType(featureType: UsageLimitFeatureType): FluentBuilder = apply { this.featureType = featureType }
        override fun limitType(limitType: UsageLimitLimitType): FluentBuilder = apply { this.limitType = limitType }
        override fun period(period: UsageLimitPeriod): FluentBuilder = apply { this.period = period }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
