// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot schedule. You can set a regular interval for creating
 * snapshots of a cluster. You can also schedule snapshots for specific dates.
 */
class CreateSnapshotScheduleResponse private constructor(builder: BuilderImpl) {
    /**
     * The number of clusters associated with the schedule.
     */
    val associatedClusterCount: Int? = builder.associatedClusterCount
    /**
     * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
     */
    val associatedClusters: List<ClusterAssociatedToSchedule>? = builder.associatedClusters
    /**
     *
     */
    val nextInvocations: List<Instant>? = builder.nextInvocations
    /**
     * A list of ScheduleDefinitions.
     */
    val scheduleDefinitions: List<String>? = builder.scheduleDefinitions
    /**
     * The description of the schedule.
     */
    val scheduleDescription: String? = builder.scheduleDescription
    /**
     * A unique identifier for the schedule.
     */
    val scheduleIdentifier: String? = builder.scheduleIdentifier
    /**
     * An optional set of tags describing the schedule.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSnapshotScheduleResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotScheduleResponse(")
        append("associatedClusterCount=$associatedClusterCount,")
        append("associatedClusters=$associatedClusters,")
        append("nextInvocations=$nextInvocations,")
        append("scheduleDefinitions=$scheduleDefinitions,")
        append("scheduleDescription=$scheduleDescription,")
        append("scheduleIdentifier=$scheduleIdentifier,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedClusterCount ?: 0
        result = 31 * result + (associatedClusters?.hashCode() ?: 0)
        result = 31 * result + (nextInvocations?.hashCode() ?: 0)
        result = 31 * result + (scheduleDefinitions?.hashCode() ?: 0)
        result = 31 * result + (scheduleDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSnapshotScheduleResponse

        if (associatedClusterCount != other.associatedClusterCount) return false
        if (associatedClusters != other.associatedClusters) return false
        if (nextInvocations != other.nextInvocations) return false
        if (scheduleDefinitions != other.scheduleDefinitions) return false
        if (scheduleDescription != other.scheduleDescription) return false
        if (scheduleIdentifier != other.scheduleIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSnapshotScheduleResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSnapshotScheduleResponse
        /**
         * The number of clusters associated with the schedule.
         */
        fun associatedClusterCount(associatedClusterCount: Int): FluentBuilder
        /**
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         */
        fun associatedClusters(associatedClusters: List<ClusterAssociatedToSchedule>): FluentBuilder
        /**
         *
         */
        fun nextInvocations(nextInvocations: List<Instant>): FluentBuilder
        /**
         * A list of ScheduleDefinitions.
         */
        fun scheduleDefinitions(scheduleDefinitions: List<String>): FluentBuilder
        /**
         * The description of the schedule.
         */
        fun scheduleDescription(scheduleDescription: String): FluentBuilder
        /**
         * A unique identifier for the schedule.
         */
        fun scheduleIdentifier(scheduleIdentifier: String): FluentBuilder
        /**
         * An optional set of tags describing the schedule.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of clusters associated with the schedule.
         */
        var associatedClusterCount: Int?
        /**
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         */
        var associatedClusters: List<ClusterAssociatedToSchedule>?
        /**
         *
         */
        var nextInvocations: List<Instant>?
        /**
         * A list of ScheduleDefinitions.
         */
        var scheduleDefinitions: List<String>?
        /**
         * The description of the schedule.
         */
        var scheduleDescription: String?
        /**
         * A unique identifier for the schedule.
         */
        var scheduleIdentifier: String?
        /**
         * An optional set of tags describing the schedule.
         */
        var tags: List<Tag>?

        fun build(): CreateSnapshotScheduleResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedClusterCount: Int? = null
        override var associatedClusters: List<ClusterAssociatedToSchedule>? = null
        override var nextInvocations: List<Instant>? = null
        override var scheduleDefinitions: List<String>? = null
        override var scheduleDescription: String? = null
        override var scheduleIdentifier: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateSnapshotScheduleResponse) : this() {
            this.associatedClusterCount = x.associatedClusterCount
            this.associatedClusters = x.associatedClusters
            this.nextInvocations = x.nextInvocations
            this.scheduleDefinitions = x.scheduleDefinitions
            this.scheduleDescription = x.scheduleDescription
            this.scheduleIdentifier = x.scheduleIdentifier
            this.tags = x.tags
        }

        override fun build(): CreateSnapshotScheduleResponse = CreateSnapshotScheduleResponse(this)
        override fun associatedClusterCount(associatedClusterCount: Int): FluentBuilder = apply { this.associatedClusterCount = associatedClusterCount }
        override fun associatedClusters(associatedClusters: List<ClusterAssociatedToSchedule>): FluentBuilder = apply { this.associatedClusters = associatedClusters }
        override fun nextInvocations(nextInvocations: List<Instant>): FluentBuilder = apply { this.nextInvocations = nextInvocations }
        override fun scheduleDefinitions(scheduleDefinitions: List<String>): FluentBuilder = apply { this.scheduleDefinitions = scheduleDefinitions }
        override fun scheduleDescription(scheduleDescription: String): FluentBuilder = apply { this.scheduleDescription = scheduleDescription }
        override fun scheduleIdentifier(scheduleIdentifier: String): FluentBuilder = apply { this.scheduleIdentifier = scheduleIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
