// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * The result of the CreateSnapshotCopyGrant action.
 */
class CreateSnapshotCopyGrantRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
     * permission. If no key is specified, the default key is used.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the snapshot copy grant. This name must be unique in the region for the
     * Amazon Web Services account.
     * Constraints:
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * Alphabetic characters must be lowercase.
     * First character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Must be unique for all clusters within an Amazon Web Services account.
     */
    val snapshotCopyGrantName: String? = builder.snapshotCopyGrantName
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSnapshotCopyGrantRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotCopyGrantRequest(")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSnapshotCopyGrantRequest

        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSnapshotCopyGrantRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSnapshotCopyGrantRequest
        /**
         * The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
         * permission. If no key is specified, the default key is used.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the snapshot copy grant. This name must be unique in the region for the
         * Amazon Web Services account.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         */
        fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
         * permission. If no key is specified, the default key is used.
         */
        var kmsKeyId: String?
        /**
         * The name of the snapshot copy grant. This name must be unique in the region for the
         * Amazon Web Services account.
         * Constraints:
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * Alphabetic characters must be lowercase.
         * First character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Must be unique for all clusters within an Amazon Web Services account.
         */
        var snapshotCopyGrantName: String?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): CreateSnapshotCopyGrantRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsKeyId: String? = null
        override var snapshotCopyGrantName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateSnapshotCopyGrantRequest) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
            this.tags = x.tags
        }

        override fun build(): CreateSnapshotCopyGrantRequest = CreateSnapshotCopyGrantRequest(this)
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun snapshotCopyGrantName(snapshotCopyGrantName: String): FluentBuilder = apply { this.snapshotCopyGrantName = snapshotCopyGrantName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
