// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
class CreateHsmConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * A text description of the HSM configuration to be created.
     */
    val description: String? = builder.description
    /**
     * The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    val hsmConfigurationIdentifier: String? = builder.hsmConfigurationIdentifier
    /**
     * The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    val hsmIpAddress: String? = builder.hsmIpAddress
    /**
     * The name of the partition in the HSM where the Amazon Redshift clusters will store their
     * database encryption keys.
     */
    val hsmPartitionName: String? = builder.hsmPartitionName
    /**
     * The password required to access the HSM partition.
     */
    val hsmPartitionPassword: String? = builder.hsmPartitionPassword
    /**
     * The HSMs public certificate file. When using Cloud HSM, the file name is
     * server.pem.
     */
    val hsmServerPublicCertificate: String? = builder.hsmServerPublicCertificate
    /**
     * A list of tag instances.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateHsmConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHsmConfigurationRequest(")
        append("description=$description,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("hsmIpAddress=$hsmIpAddress,")
        append("hsmPartitionName=$hsmPartitionName,")
        append("hsmPartitionPassword=$hsmPartitionPassword,")
        append("hsmServerPublicCertificate=$hsmServerPublicCertificate,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmIpAddress?.hashCode() ?: 0)
        result = 31 * result + (hsmPartitionName?.hashCode() ?: 0)
        result = 31 * result + (hsmPartitionPassword?.hashCode() ?: 0)
        result = 31 * result + (hsmServerPublicCertificate?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateHsmConfigurationRequest

        if (description != other.description) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (hsmIpAddress != other.hsmIpAddress) return false
        if (hsmPartitionName != other.hsmPartitionName) return false
        if (hsmPartitionPassword != other.hsmPartitionPassword) return false
        if (hsmServerPublicCertificate != other.hsmServerPublicCertificate) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateHsmConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateHsmConfigurationRequest
        /**
         * A text description of the HSM configuration to be created.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier to be assigned to the new Amazon Redshift HSM configuration.
         */
        fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder
        /**
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         */
        fun hsmIpAddress(hsmIpAddress: String): FluentBuilder
        /**
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their
         * database encryption keys.
         */
        fun hsmPartitionName(hsmPartitionName: String): FluentBuilder
        /**
         * The password required to access the HSM partition.
         */
        fun hsmPartitionPassword(hsmPartitionPassword: String): FluentBuilder
        /**
         * The HSMs public certificate file. When using Cloud HSM, the file name is
         * server.pem.
         */
        fun hsmServerPublicCertificate(hsmServerPublicCertificate: String): FluentBuilder
        /**
         * A list of tag instances.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A text description of the HSM configuration to be created.
         */
        var description: String?
        /**
         * The identifier to be assigned to the new Amazon Redshift HSM configuration.
         */
        var hsmConfigurationIdentifier: String?
        /**
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         */
        var hsmIpAddress: String?
        /**
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their
         * database encryption keys.
         */
        var hsmPartitionName: String?
        /**
         * The password required to access the HSM partition.
         */
        var hsmPartitionPassword: String?
        /**
         * The HSMs public certificate file. When using Cloud HSM, the file name is
         * server.pem.
         */
        var hsmServerPublicCertificate: String?
        /**
         * A list of tag instances.
         */
        var tags: List<Tag>?

        fun build(): CreateHsmConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var hsmConfigurationIdentifier: String? = null
        override var hsmIpAddress: String? = null
        override var hsmPartitionName: String? = null
        override var hsmPartitionPassword: String? = null
        override var hsmServerPublicCertificate: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateHsmConfigurationRequest) : this() {
            this.description = x.description
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.hsmIpAddress = x.hsmIpAddress
            this.hsmPartitionName = x.hsmPartitionName
            this.hsmPartitionPassword = x.hsmPartitionPassword
            this.hsmServerPublicCertificate = x.hsmServerPublicCertificate
            this.tags = x.tags
        }

        override fun build(): CreateHsmConfigurationRequest = CreateHsmConfigurationRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun hsmConfigurationIdentifier(hsmConfigurationIdentifier: String): FluentBuilder = apply { this.hsmConfigurationIdentifier = hsmConfigurationIdentifier }
        override fun hsmIpAddress(hsmIpAddress: String): FluentBuilder = apply { this.hsmIpAddress = hsmIpAddress }
        override fun hsmPartitionName(hsmPartitionName: String): FluentBuilder = apply { this.hsmPartitionName = hsmPartitionName }
        override fun hsmPartitionPassword(hsmPartitionPassword: String): FluentBuilder = apply { this.hsmPartitionPassword = hsmPartitionPassword }
        override fun hsmServerPublicCertificate(hsmServerPublicCertificate: String): FluentBuilder = apply { this.hsmServerPublicCertificate = hsmServerPublicCertificate }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
